#pragma once

#include "ui_propello.h"
#include "porta_def.h"

class porta;

class Propello : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    Propello(QWidget* parent = 0);
    virtual ~Propello();
    void processRawFrame(unsigned char* addr, int blockIndex, int header);

private:
    bool loadMode(int mode, int rfmode);
    bool loadMasterPreset();
    void loadParams();
    void setupControls();
    void refreshParams();
    void stepMotor(bool fwd);
    QString getParamStringValue(QString);

private:
    QString m_firmwarePath;
    QString m_settingsPath;
    int m_cineSize;
    int m_motorstart;
    double m_motorpos;
    porta* m_porta;
    probeInfo m_probeInfo;

signals:
    void showInfo(int);

private slots:
    void initHardware();
    void runImage();
    void stopImage();
    void showSystemID();
    void getFirmwarePath();
    void getSettingsPath();
    void setCineSize();
    void onDetect();
    void onProbeAttributes();
    void onCaptureChange(int);
    void onDataSelection(int);
    void onShowInfo(int);
    void onHomeMotor();
    void incParamMotor();
    void decParamMotor();
    void onApply();
    void cineScroll(int);
    void onStoreVolume();
    void incParam();
    void decParam();
};
