#include "stdafx.h"
#include "PropelloBDisplay.h"

PropelloBDisplay::PropelloBDisplay(QWidget* parent) : PropelloDisplay(parent)
{
}

PropelloBDisplay::~PropelloBDisplay()
{
}

bool PropelloBDisplay::loadColorMap(const QString file)
{
    QImage img;
    if (!img.load(file))
    {
        return false;
    }

    return portaImportColorMap(0, (unsigned int*)img.constBits()) != 0;
}

bool PropelloBDisplay::setImgData()
{
    bool ret = false;

    if (!m_image || m_index < 0)
    {
        return false;
    }

    unsigned char* buffer = m_image->bits();
    int mode = portaGetCurrentMode();

    if (mode == ColourMode || mode == DualColourMode || mode == TriplexMode)
    {
        ret = portaGetColorImage(m_index, buffer) != 0;
    }
    else
    {
        ret = portaGetBwImage(m_index, buffer, true) != 0;
    }

    if (ret)
    {
        scene()->invalidate();
    }

    return true;
}
