%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% loads the ultrasound data saved from the Sonix software, converts them
%% into the correct format and calls the corresponding functions to
%% correctly display them onto the screen
%%
%% Inputs:  
%%     filename - The path of the data to open
%%     framenum - The frame number of frames to read
%%
%% Return:
%%     Im -         The image data returned into a 3D array (h, w, numframes)
%%     header -     The file header information  
%%
%% Corina Leung, corina.leung@ultrasonix.com
%% Ultrasonix Medical Corporation Dec 2007
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function RPview(filename)

% fileExt = filename(end-3:end);
% 
fid= fopen(filename, 'r');
% 
if( fid == -1)
    error('Cannot open file');
end

% read the header info
hinfo = fread(fid, 19, 'int32'); 

% load the header information into a structure and save under a separate file
header = struct('filetype', 0, 'nframes', 0, 'w', 0, 'h', 0, 'ss', 0, 'ul', [0,0], 'ur', [0,0], 'br', [0,0], 'bl', [0,0], 'probe',0, 'txf', 0, 'sf', 0, 'dr', 0, 'ld', 0, 'extra', 0);
header.filetype = hinfo(1);
header.nframes = hinfo(2);
header.w = hinfo(3);
header.h = hinfo(4);
header.ss = hinfo(5);
header.ul = [hinfo(6), hinfo(7)];
header.ur = [hinfo(8), hinfo(9)];
header.br = [hinfo(10), hinfo(11)];
header.bl = [hinfo(12), hinfo(13)];
header.probe = hinfo(14);
header.txf = hinfo(15);
header.sf = hinfo(16);
header.dr = hinfo(17);
header.ld = hinfo(18);
header.extra = hinfo(19);

v=[];
Im =[];
Im2 = [];

 for frame_count = 1:header.nframes
 
     if(header.filetype == 2) %.bpr
        [v,count] = fread(fid,[header.h header.w],'uchar=>uchar'); 
        Im(:,:,frame_count) = v;
   
    elseif(header.filetype == 4) %postscan B .b8
         [v,count] = fread(fid,[header.w header.h],'int8'); 
         temp = int16(v);
         Im(:,:,frame_count) = imrotate(temp, -90); 
    
    elseif(header.filetype == 8) %postscan B .b32
        % tag = fread(fid,1,'int32');
         [v,count] = fread(fid,[header.w header.h],'int32'); 
         Im(:,:,frame_count) = imrotate(v, -90); 
   
    elseif(header.filetype == 16) %rf
        tag = fread(fid,1,'int32');
        [v,count] = fread(fid,[header.h header.w],'int16'); 
        Im(:,:,frame_count) = int16(v);
        
    elseif(header.filetype == 32) %.mpr
        tag = fread(fid,1,'int32');
        [v,count] = fread(fid,[header.w header.h],'int16'); 
        Im(:,frame_count) = v;
    
    elseif(header.filetype == 64) %.m
        [v,count] = fread(fid,'uint8');
        temp = reshape(v,header.w,header.h);  
        Im(:,:,frame_count) = imrotate(temp,-90);
        
    elseif(header.filetype == 128) %.drf
        [v,count] = fread(fid,header.h,'int16'); 
        Im(:,:,frame_count) = int16(reshape(v,header.w,header.h));
        
    elseif(header.filetype == 512) %crf
        [v,count] = fread(fid,header.extra*header.w*header.h,'int16'); 
        Im(:,:,frame_count) = reshape(v,header.h,header.w*header.extra);
   
    elseif(header.filetype == 256) %.pw
        [v,count] = fread(fid,'uint8');
        temp = reshape(v,header.w,header.h);  
        Im(:,:,frame_count) = imrotate(temp,-90);
                
     elseif(header.filetype == 1024) %.col
         [v,count] = fread(fid,header.w*header.h,'int'); 
         temp = reshape(v,header.w,header.h);
         temp2 = imrotate(temp, -90); 
         Im(:,:,frame_count) = mirror(temp2,header.w);
        
    elseif((header.filetype == 2048)) %color .cvv (the new format as of SONIX version 3.1X)
        % velocity data
        [v,count] = fread(fid,header.w*header.h,'uint8'); 
        temp = reshape(v,header.w,header.h); 
        temp2 = imrotate(temp, -90);
        Im(:,:,frame_count) = mirror(temp2,header.w);
        
        % sigma
        [v,count] =fread(fid, header.w*header.h,'uint8');
        temp = reshape(v,header.w, header.h);
        temp2 = imrotate(temp, -90);
        Im2(:,:,frame_count) = mirror(temp2,header.w);
    
    elseif(header.filetype == 4096) %color vel
        [v,count] = fread(fid,header.w*header.h,'uchar=>uchar'); 
        temp = reshape(v,header.w,header.h); 
        temp2 = imrotate(temp, -90);
        Im(:,:,frame_count) = mirror(temp2,header.w);
        
     elseif(header.filetype == 8192) %.el
        [v,count] = fread(fid,header.w*header.h,'int32'); 
        temp = reshape(v,header.w,header.h);
        temp2 = imrotate(temp, -90);
        Im(:,:,frame_count) = mirror(temp2,header.w);
    
    elseif(header.filetype == 16384) %.elo
        [v,count] = fread(fid,header.w*header.h,'uchar=>uchar'); 
        temp = int16(reshape(v,header.w,header.h));
        temp2 = imrotate(temp, -90); 
        Im(:,:,frame_count) = mirror(temp2,header.w);
  
    elseif(header.filetype == 32768) %.epr
        [v,count] = fread(fid,header.w*header.h,'uchar=>uchar'); 
        Im(:,:,frame_count) = int16(reshape(v,header.h,header.w));
       
    elseif(header.filetype == 65536) %.ecg
        [v,count] = fread(fid,header.w*header.h,'uchar=>uchar'); 
        Im(:,frame_count) = v;
    else
        disp('Data not supported');
    end
end
    
fclose(fid);

% for RF data, plot both the RF center line and image 
if(header.filetype == 16 || header.filetype == 512)
    RPviewrf(Im, header, 1);  
           
else if(header.filetype == 2 || header.filetype == 4 || header.filetype == 8 || header.filetype == 64 || header.filetype == 1024)
        figure, imagesc(Im(:,:,1));
        colormap(gray); 
        
        if(header.filetype == 2) %.bpr
            imtitle = 'Prescan B: Image';
        elseif(header.filetype == 4) %.b8
            imtitle = 'Postscan B (8 bit): Image';
        elseif(header.filetype == 8) %.b32
            imtitle = 'Postscan B (32 bit): Image';
        elseif(header.filetype == 64) %.m
            imtitle = 'M Spectrum(8 bit): Image ';
            xlabel('Time (s)');  
        elseif(header.filetype == 1024) %.col
            imtitle = 'B + C Doppler Overlay : Image ';
        end
        
        title(imtitle);
    
    end
end
