%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% loads the ultrasound RF data saved from the Sonix software. Clicking on
%% the raw RF image will display that particular line of RF data.
%%
%% Inputs:  
%%     rawIm - The data to view
%%     header - The file header
%%     framenum - The frame number to show
%%
%% Corina Leung, corina.leung@ultrasonix.com
%% Ultrasonix Medical Corporation Jan 31, 2008
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function RPviewrf(rawIm, header, framenum)

Im = sqrt(abs(Hilbert(rawIm(:,:,framenum))));
figure, imagesc(Im); colormap(gray);
figure, SUBPLOT(3,1,1);
imagesc(Im);
rfimtitle = sprintf('Env Image from RF 16 bit%d',framenum);
title(rfimtitle);
colormap(gray);

while(-1)
    [x,y] = ginput(1);

    Line = round(x);   
    
    if(header.filetype == 16)
        if(x<1 || x>header.w)
            return;
        end    
    else
         if(x<1 || x>header.h)
            return;
        end
    end
    
    RFLine = rawIm(:,Line,framenum);
    
    %plot RF line
    SUBPLOT(3,1,2);
    plot(RFLine, 'b'); 
    AXIS([0 length(RFLine) min(RFLine) max(RFLine)]); 
    rftitle = sprintf('RF Line: %d', Line);
    title(rftitle);  
    
    %plot frequency content of the chosen RF line
    filterOrder = 5;    % Butterworth filter order
    FFTLength = 1024;   % Length of FFT calculation

    Fs = 40e6;      % sampling frequency
    Ts = 1/Fs;      % period
    c  = 1540;      % speed of sound m/s
    L  = header.nframes;         % number of samples
    D  = L*c/(Fs*2);        % Depth in meter
    T  = D/(c/2);           % total time
    t  = 0:Ts:T; t = t(1:L);
    
    Y = fft(RFLine,FFTLength);
    Spectrum1 = Y.* conj(Y) / FFTLength;
    
    f = (Fs/1e6)*(0:FFTLength/2)/FFTLength;
    SUBPLOT(3,1,3);
    plot(f,Spectrum1(1:(FFTLength/2 + 1)),'b')
    %AXIS([0 (Fs/2e6) 0 5e5]);
    title('Frequency Content of the RF Line');
    xlabel('Frequency (MHz)');
    
    min(RFLine)
    max(RFLine)
end


% 
a = rawIm;
for k=1:size(a,2)-1;
    ncc(k)=sum(a(:,k).*a(:,k+1))/sqrt(sum(a(:,k).^2)*sum(a(:,k+1).^2));
end;
