% ///////////////////////////////////////////////////////////////////////
% to view single frames
% close all
% clear all
% clc
% filename = 'D:\1_single_rf.rf';
% RPview(filename);

% ////////////////////////////////////////////////////////////////////
% To view volumes saved using either auto or manual motor control mode
 close all
 clear all
 clc
 datapath = 'D:\1_auto_postscan.vol';
 numVol = 1;

%loads the volume information and data from the file
[volume, header] = loadvol(datapath, numVol);

%sample slice from volume
sampleSlice = volume(:,:,floor(header.fpV/2));
            
if(header.datatype == 0)
     SUBPLOT(3,1,1); imagesc(sampleSlice); colormap(gray);
     title('PreScan B data');
    
     SUBPLOT(3,1,2);
     imagesc(squeeze(volume(header.h/2,:,:))); colormap(gray);
     title('X-axis slice');
     
     SUBPLOT(3,1,3);
     imagesc(squeeze(volume(:,header.w/2,:))); colormap(gray);
     title('Y-axis slice');
end

if(header.datatype == 1)
     SUBPLOT(3,1,1); imagesc(sampleSlice); colormap(gray);
     title('PostScan B data');
    
     SUBPLOT(3,1,2);
     imagesc(squeeze(volume(header.h/2,:,:))); colormap(gray);
     title('X-axis slice');
     
     SUBPLOT(3,1,3);
     imagesc(squeeze(volume(:,header.w/2,:))); colormap(gray);
     title('Y-axis slice');
end

if(header.datatype == 2)
    Line = floor(header.w/2); %center line
    RFLine = sampleSlice(:,Line); 
    frame = squeeze(sampleSlice);
    
    SUBPLOT(2,1,1); plot(RFLine, 'b'); 
    AXIS([0 length(RFLine) min(RFLine) max(RFLine)]);
    title('Raw RF data - Center Line');

    SUBPLOT(2,1,2); 
    sample = uint16(sampleSlice);
    imRF = sqrt(abs(Hilbert(sample)));
    imagesc(imRF); colormap(gray);
    title('Raw RF image');
end
