#pragma once

#include "ui_porta.h"

class PortaDemo : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    PortaDemo(QWidget* parent = 0);
    virtual ~PortaDemo();
    void processRawFrame(unsigned char* addr, int blockIndex, int header);

private:
    bool initMode();
    void setupControls();
    void readProbes();
    void loadPresets();
    void loadParams();
    void refreshParamValue();
    QString getParamStringValue(QString);
    double RawMiniTeeToTemperature(int voltage);
    double RawMiniTnTeeToPhase(int voltage);

private:
    QString m_firmwarePath;
    QString m_settingsPath;
    QString m_licensePath;
    int m_cineSize;
    double m_tnTEETemperature;
    double m_tnTEEPhase;

signals:
    void headerInfo(int);

private slots:
    void initHardware();
    void runImage();
    void stopImage();
    void showSystemID();
    void getFirmwarePath();
    void getSettingsPath();
    void setCineSize();
    void selectProbe1();
    void selectProbe2();
    void selectProbe3();
    void selectPreset(QString preset);
    void savePreset();
    void incParam();
    void decParam();
    void changeMode(int sel);
    void cineScroll(int value);
    void onSelectParam();
    void onHeaderInfo(int header);
};
