#pragma once

#include "qgraphicsview.h"
#define OVERLAYCOLOR (Qt::yellow)

class PortaDisplay : public QGraphicsView
{    
public:
    PortaDisplay(QWidget* parent = 0);
    virtual ~PortaDisplay();

    bool init(int index, int mode);
    virtual bool setImgData(int /*header*/) { return true; }

protected:
    virtual void drawBackground(QPainter*, const QRectF&);
    virtual void resizeEvent(QResizeEvent*);

protected:
    void getOptDims(int& w, int& h);
    void setupBuffer(int w, int h);
    double getSampleSize(int samplingFreq, int vsound);
    int micronsToUSSamples(int microns, int samplingFreq, int vsound);
    int usSamplesToMicrons(int samples, int samplingFreq, int vsound);

protected:

    int m_index;
    int m_mode;
    QImage* m_image;
};
