#include "stdafx.h"
#include "PortaMDisplay.h"

PortaMDisplay::PortaMDisplay(QWidget* parent) : PortaDisplay(parent)
{
}

PortaMDisplay::~PortaMDisplay()
{
}

bool PortaMDisplay::setImgData(int /*header*/)
{
    if (!m_image || m_index < 0)
    {
        return false;
    }

    unsigned char* buffer = m_image->bits();

    bool ret = portaGetBwImage(m_index, buffer, true) != 0;

    if (ret)
    {
        scene()->invalidate();
    }

    return ret;
}

// draws the foreground graphics
void PortaMDisplay::drawForeground(QPainter* painter, const QRectF& r)
{
    QGraphicsView::drawBackground(painter, r);

    if (m_mode == MMode || m_mode == PwMode || m_mode == TriplexMode)
    {
        drawTimeScale(painter, m_mode);
    }
}

// draw time scale
void PortaMDisplay::drawTimeScale(QPainter* painter, int mode)
{
    int lrp, linesPerSecond;
    double i = 0, tick = 1;

    // get lrp value in microseconds
    lrp = portaGetParam((mode == MMode) ? prmMSweep : prmPwSweep);
    if (!lrp)
    {
        return;
    }

    linesPerSecond = 1000000 / lrp;
    tick = (double)linesPerSecond / 10.0;

    if (!tick)
    {
        return;
    }

    QPainterPath pp;

    while (i < width())
    {
        pp.moveTo((int)i, 0);
        if (!((int)i % linesPerSecond))
        {
            pp.lineTo((int)i, 8);
        }
        else
        {
            pp.lineTo((int)i, 4);
        }

        i += tick;
    }

    painter->setPen(OVERLAYCOLOR);
    painter->drawPath(pp);
}
