#include "porta_wrapper.h"
#include "porta.h"

porta::porta()
{
}

porta::~porta()
{
}

bool porta::init(int cineSize, const char* firmwarePath, const char* settingsPath, const char* licensePath, const char* lutPath, int usm,
    int pci, int hv, int ddr,
    int channels)
{
    return portaInit(cineSize, firmwarePath, settingsPath, licensePath, lutPath, usm, pci, hv, ddr, channels) ? true : false;
}

bool porta::shutdown()
{
    portaShutdown();
    return true;
}

bool porta::isConnected() const
{
    return portaIsConnected() ? true : false;
}

bool porta::getProbeInfo(probeInfo& nfo)
{
    return portaGetProbeInfo(nfo) ? true : false;
}

bool porta::testElectronicComponent(int id)
{
    return portaTestElectronicComponent(id) ? true : false;
}

int porta::getProbeID(int connector) const
{
    return portaGetProbeID(connector);
}

bool porta::activateProbeConnector(int connector)
{
    return portaActivateProbeConnector(connector) ? true : false;
}

bool porta::getProbeName(char* name, unsigned int sz, int id) const
{
    return portaGetProbeName(name, sz, id) ? true : false;
}

bool porta::selectProbe(int id) const
{
    return portaSelectProbe(id) ? true : false;
}

int porta::getCurrentProbeID() const
{
    return portaGetCurrentProbeID();
}

bool porta::findMasterPreset(char* path, unsigned int sz, int probe) const
{
    return portaFindMasterPreset(path, sz, probe) ? true : false;
}

bool porta::savePreset(const char* path, bool overwrite)
{
    return portaSavePreset(path, overwrite) ? true : false;
}

bool porta::getPresetProbeID(const char* path, int& probeid1, int& probeid2, int& probeid3) const
{
    return portaGetPresetProbeID(path, probeid1, probeid2, probeid3) ? true : false;
}

bool porta::isMasterPreset(const char* path) const
{
    return portaIsMasterPreset(path) ? true : false;
}

bool porta::loadPreset(const char* path)
{
    return portaLoadPreset(path) ? true : false;
}

bool porta::loadMasterPreset()
{
    return portaLoadMasterPreset() ? true : false;
}

bool porta::setCustomDMA(bool enable, int physicaladdress, int size)
{
    return portaSetCustomDMA(enable, physicaladdress, size) ? true : false;
}

void porta::setSleepDelay(int delay)
{
    portaSetSleepDelay(delay);
}

bool porta::initImagingMode(imagingMode mode)
{
    return portaInitMode(mode) ? true : false;
}

imagingMode porta::getCurrentMode() const
{
    return portaGetCurrentMode();
}

int porta::getFrameRate() const
{
    return portaGetFrameRate();
}

int porta::getDataFrameRate() const
{
    return portaGetDataFrameRate();
}

bool porta::runImage()
{
    return portaRunImage() ? true : false;
}

bool porta::stopImage()
{
    return portaStopImage() ? true : false;
}

bool porta::isImaging() const
{
    return portaIsImaging() ? true : false;
}

int porta::getFrameCount(unsigned int index)
{
    return portaGetFrameCount(index);
}

void porta::clearCine()
{
    portaClearCine();
}

const unsigned char* porta::getFrameAddress(int index, int frame)
{
    return portaGetFrameAddress(index, frame);
}

void porta::setDisplayCallback(int index, PORTA_IMG_CALLBACK fn, void* prm)
{
    portaSetDisplayCallback(index, fn, prm);
}

void porta::setRawDataCallback(PORTA_DATA_CALLBACK fn, void* prm)
{
    portaSetRawDataCallback(fn, prm);
}

void porta::setPreRunCallback(PORTA_PRERUN_CALLBACK fn, void* prm)
{
    portaSetPreRunCallback(fn, prm);
}

bool porta::setWatchdog(int timeout)
{
    return portaSetWatchdog(timeout) ? true : false;
}

bool porta::getSystemId(char* sysid, unsigned int sz)
{
    return portaGetSystemId(sysid, sz) ? true : false;
}

bool porta::signalBnc()
{
    return portaSignalBnc() ? true : false;
}

bool porta::pollBnc()
{
    return portaPollBnc() ? true : false;
}

bool porta::ackBnc()
{
    return portaAckBnc() ? true : false;
}

bool porta::readPowerValues(double* pv, double* nv, double* pav, double* nav, int& tmout, double& tolerance)
{
    return portaReadPowerValues(pv, nv, pav, nav, tmout, tolerance) ? true : false;
}

unsigned char* porta::getCineStart(unsigned int blockid)
{
    return portaGetCineStart(blockid);
}

int porta::getFrameSize(int displayIndex)
{
    return portaGetFrameSize(displayIndex);
}

int porta::getParam(const char* prm) const
{
    return portaGetParam(prm);
}

bool porta::getParam(const char* prm, char* val, int sz) const
{
    return portaGetParamS(prm, val, sz) ? true : false;
}

bool porta::setParam(const char* prm, const char* val) const
{
    return portaSetParamS(prm, val) ? true : false;
}

bool porta::getParam(const char* prm, int& val) const
{
    return portaGetParamI(prm, val) ? true : false;
}

bool porta::setParam(const char* prm, int val)
{
    return portaSetParamI(prm, val) ? true : false;
}

bool porta::getParam(const char* prm, portaRect& val) const
{
    return portaGetParamR(prm, val) ? true : false;
}

bool porta::setParam(const char* prm, portaRect val)
{
    return portaSetParamR(prm, val) ? true : false;
}

bool porta::getParam(const char* prm, portaCurve& val) const
{
    return portaGetParamC(prm, val) ? true : false;
}

bool porta::setParam(const char* prm, portaCurve val)
{
    return portaSetParamC(prm, val) ? true : false;
}

bool porta::getParam(const char* prm, portaGainCurve& val) const
{
    return portaGetParamGC(prm, val) ? true : false;
}

bool porta::setParam(const char* prm, portaGainCurve val)
{
    return portaSetParamGC(prm, val) ? true : false;
}

bool porta::cycleParam(const char* prm, bool fwd, bool wrap)
{
    return portaCycleParam(prm, fwd, wrap) ? true : false;
}

bool porta::getParamMinMax(const char* prm, int& min, int& max) const
{
    return portaGetParamMinMax(prm, min, max) ? true : false;
}

bool porta::getParamType(const char* prm, portaVarType& type) const
{
    return portaGetParamType(prm, type) ? true : false;
}

bool porta::setDisplayDimensions(int index, int w, int h)
{
    return portaSetDisplayDimensions(index, w, h) ? true : false;
}

bool porta::getDisplayDimensions(int index, int& x, int& y) const
{
    return portaGetDisplayDimensions(index, x, y) ? true : false;
}

bool porta::getBwImage(int index, unsigned char*& img, bool useChroma) const
{
    return portaGetBwImage(index, img, useChroma) ? true : false;
}

bool porta::getColorImage(int index, unsigned char*& img) const
{
    return portaGetColorImage(index, img) ? true : false;
}

bool porta::getColorData(int index, unsigned char*& img, bool velocity, bool prescan, bool copy) const
{
    return portaGetColorData(index, img, velocity, prescan, copy) ? true : false;
}

bool porta::getColorVV(int index, unsigned char*& img) const
{
    return portaGetColorVV(index, img) ? true : false;
}

int porta::getDisplayFrameCount(int index)
{
    return portaGetDisplayFrameCount(index);
}

bool porta::processCineImage(int index, int frame)
{
    return portaProcessCineImage(index, frame) ? true : false;
}

bool porta::importChromaMap(int index, const unsigned int* lut)
{
    return portaImportChromaMap(index, lut) ? true : false;
}

bool porta::importColorMap(int index, const unsigned int* lut)
{
    return portaImportColorMap(index, lut) ? true : false;
}

bool porta::getMicronsPerPixel(int index, int& mx, int& my) const
{
    return portaGetMicronsPerPixel(index, mx, my) ? true : false;
}

bool porta::getPixelCoordinates(int index, int line, int sample, int& xOut, int& yOut, bool bColor, int addAngle) const
{
    return portaGetPixelCoordinates(index, line, sample, xOut, yOut, bColor, addAngle) ? true : false;
}

bool porta::getUltrasoundCoordinates(int index, int x, int y, int& xOut, int& yOut, bool bColor, int addAngle) const
{
    return portaGetUltrasoundCoordinates(index, x, y, xOut, yOut, bColor, addAngle) ? true : false;
}

bool porta::getHorizontalArcRect(int index, portaRect& arcRect, bool color, bool top, int sampleOverride) const
{
    return portaGetHorizontalArcRect(index, arcRect, color, top, sampleOverride) ? true : false;
}

bool porta::getROI(int index, int* xOut, int* yOut) const
{
    return portaGetROI(index, xOut, yOut) ? true : false;
}

bool porta::getColorBox(int index, int* xOut, int* yOut) const
{
    return portaGetColorBox(index, xOut, yOut) ? true : false;
}

bool porta::getNewColorBox(int index, int x, int y, portaRect& colorBox, bool center)
{
    return portaGetNewColorBox(index, x, y, colorBox, center) ? true : false;
}

int porta::getLinePosition(int index) const
{
    return portaGetLinePosition(index);
}

bool porta::getListParam(char* prm, unsigned int sz, int index)
{
    return portaGetListParam(prm, sz, index) ? true : false;
}

int porta::getNumParams()
{
    return portaGetNumParams();
}

double porta::goToPosition(double angle)
{
    return portaGoToPosition(angle);
}

double porta::stepMotor(bool cw, int steps)
{
    return portaStepMotor(cw, steps);
}

void porta::setMotorHomeParams(int framesOffCenter)
{
    portaSetMotorHomeParams(framesOffCenter);
}

void porta::setMotorActive(bool run)
{
    portaSetMotorActive(run);
}

void porta::setMotorHomeOnRun(bool enable)
{
    //portaSetMotorHomeOnRun(enable)
}

void porta::setMotorPowerState(bool keepOnUntilDisconnect)
{
    //portaSetMotorPowerState(keepOnUntilDisconnect);
}

void porta::setPowerTestParams(int tmout, int numQuickLevels, int* levels)
{
    portaSetPowerTestParams(tmout, numQuickLevels, levels);
}
