#pragma once

#include "porta_def.h"

class porta
{
public:
    porta();
    ~porta();

    // initialization functions
    bool init(int cineSize, const char* firmwarePath, const char* settingsPath, const char* licensePath, const char* lutPath, int usm,
        int pci, int hv, int ddr,
        int channels);
    bool shutdown();
    bool isConnected() const;
    bool getSystemId(char* sysid, unsigned int sz);

    // bnc functions
    bool signalBnc();
    bool pollBnc();
    bool ackBnc();

    // probe functions
    bool selectProbe(int id) const;
    int getCurrentProbeID() const;
    int getProbeID(int connector) const;
    bool activateProbeConnector(int connector);
    bool getProbeName(char* name, unsigned int sz, int id) const;
    bool getProbeInfo(probeInfo& nfo);

    // testing functions
    bool testElectronicComponent(int id);
    void setPowerTestParams(int tmout, int numQuickLevels, int* levels);
    bool readPowerValues(double* pv, double* nv, double* pav, double* nav, int& tmout, double& tol);

    // acquisition functions
    bool runImage();
    bool stopImage();
    bool isImaging() const;
    void setPreRunCallback(PORTA_PRERUN_CALLBACK fn, void* prm);

    bool setWatchdog(int timeout);
    bool setCustomDMA(bool enable, int physicaladdress, int size);
    void setSleepDelay(int delay);

    // imaging mode functions
    bool initImagingMode(imagingMode mode);
    imagingMode getCurrentMode() const;

    // data acquisition functions
    void setDisplayCallback(int index, PORTA_IMG_CALLBACK fn, void* prm);
    void setRawDataCallback(PORTA_DATA_CALLBACK fn, void* prm);
    int getFrameCount(unsigned int index);
    const unsigned char* getFrameAddress(int index, int frame);
    unsigned char* getCineStart(unsigned int blockid);
    void clearCine();
    int getFrameSize(int displayIndex);

    // preset functions
    bool loadMasterPreset();
    bool loadPreset(const char* path);
    bool savePreset(const char* path, bool overwrite);
    bool findMasterPreset(char* path, unsigned int sz, int probe) const;
    bool isMasterPreset(const char* path) const;
    bool getPresetProbeID(const char* path, int& probeid1, int& probeid2, int& probeid3) const;

    // frame rate functions
    int getFrameRate() const;
    int getDataFrameRate() const;

    // imaging parameter functions
    int getParam(const char* prm) const;
    bool getParam(const char* prm, char* val, int sz) const;
    bool setParam(const char* prm, const char* val) const;
    bool getParam(const char* prm, int& val) const;
    bool setParam(const char* prm, int val);
    bool getParam(const char* prm, portaRect& val) const;
    bool setParam(const char* prm, portaRect val);
    bool getParam(const char* prm, portaCurve& val) const;
    bool setParam(const char* prm, portaCurve val);
    bool getParam(const char* prm, portaGainCurve& val) const;
    bool setParam(const char* prm, portaGainCurve val);
    bool cycleParam(const char* prm, bool fwd, bool wrap = false);
    bool getParamMinMax(const char* prm, int& min, int& max) const;
    bool getParamType(const char* prm, portaVarType& type) const;
    bool getListParam(char* prm, unsigned int sz, int prmNum);
    int getNumParams();

    // display setup functions
    bool setDisplayDimensions(int index, int x, int y);
    bool getDisplayDimensions(int index, int& x, int& y) const;

    // processed data retrieval functions
    bool getBwImage(int index, unsigned char*& img, bool useChroma) const;
    bool getColorImage(int index, unsigned char*& img) const;
    bool getColorData(int index, unsigned char*& img, bool velocity, bool prescan, bool copy) const;
    bool getColorVV(int index, unsigned char*& img) const;
    int getDisplayFrameCount(int index);
    bool processCineImage(int index, int frame);

    // mapping functions
    bool importChromaMap(int index, const unsigned int* lut);
    bool importColorMap(int index, const unsigned int* lut);

    // image geometry functions
    bool getMicronsPerPixel(int index, int& mx, int& my) const;
    bool getPixelCoordinates(int index, int line, int sample, int& xOut, int& yOut, bool bColor, int addAngle = 0) const;
    bool getUltrasoundCoordinates(int index, int x, int y, int& xOut, int& yOut, bool bColor, int addAngle = 0) const;

    // graphical image functions
    bool getHorizontalArcRect(int index, portaRect& arcRect, bool color, bool top, int sampleOverride = 0) const;
    bool getROI(int index, int* xOut, int* yOut) const;
    bool getColorBox(int index, int* xOut, int* yOut) const;
    bool getNewColorBox(int index, int x, int y, portaRect& colorBox, bool center);
    int getLinePosition(int index) const;

    // motor functions
    double goToPosition(double angle);
    double stepMotor(bool cw, int steps = 8);
    void setMotorHomeParams(int framesOffCenter);
    void setMotorActive(bool run);
    void setMotorHomeOnRun(bool enable);
    void setMotorPowerState(bool keepOnUntilDisconnect);
};
