#pragma once

#include <QMutex>
#include <QThread>
#include <daq_def.h>
#include "ui_texo.h"

class texoParams
{
public:
    // gather data from parameters control
    int numLines;
    int angle;
    int vsound;
    int freq;
    int txaperture;
    int power;
    QString pulse;
    int focus;

    int rxaperture;
    int gain;
    int depth;
    int delay;
    int decim;
    bool bfdelay;
    int planeWave;
};

class amplioParams
{
public:
    // IQ demodulation params
    int samplingFreq;
    int startFreq;
    int stopFreq;
    int cutoffFreq;
    // Compression table params
    int useCompression;
    int reject;
    int dynamicRg;
    int decimation;
};

class daqParams
{
public:
    unsigned int channels[4];
    int gainDelay;
    int gainOffset;
    int rxDelay;
    int decimation;
    int freeRun;
    int hpfBypass;
    int divisor;           // data size = 16GB / 2^divisor
    int externalTrigger;    // sync with Texo transmits
    int externalClock;      // set to true if external clock is provided
    int fixedTGC;
    int lnaGain;            // 0:16dB, 1:18dB, 2:21dB
    int pgaGain;            // 0:21dB, 1:24dB, 2:27dB, 3:30dB
    int biasCurrent;        // 0,1,2,...,7
};

class TexoDemo : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    TexoDemo(QWidget* parent = 0);
    virtual ~TexoDemo();
    static int onData(void*, unsigned char*, int);
    static void daqCallback(void*, int, ECallbackSources);

private:
    void setupControls();
    void readProbes();
    bool programSequence();
    bool sequenceDAQ();
    int loadDaqData(char* path, int frame);
    void displayDAQ();
    void incDaqCounter();
    bool initAmplio();
    void processTexo();
    void allocateBuffers(int szRF, int szB);
    void allocateDAQBuffers(int channels, int samples);
    void resetBuffers(int szRF, int szB);
    void reloadParams();
    void displayTexo();
    void beamformDAQ();
    class Processor : public QThread
    {
public:
        Processor(TexoDemo* inp) { m_txo = inp; }
        void run();

private:
        TexoDemo* m_txo;
    };

private:
    int m_cineSize;
    int m_scanlines;
    int m_samplesPerLine;
    int m_BsamplesPerLine;
    int m_display;
    int m_channels;
    QString m_texoFwPath;
    QString m_daqFwPath;
    int m_daqFrCount;
    char m_daqpath[256];
    int m_daqchannels;
    int m_daqsamplesPerLine;
    char* m_daqdata;
    char* m_bfdaq;
    bool m_daq80MHzSampling;
    short* m_rf;    // acq thread
    short* m_rfII;  // worker thread
    unsigned char* m_b;

    bool m_runBeamforming;
    bool m_runAmplio;

    // Acq/worker threads params
    QMutex m_txoMutex;
    QMutex m_dispMutex;

    bool m_texoIsRunning;
    Processor m_workerProcessor;

    bool m_updateDAQdisplay;

    int m_amp;
    texoParams m_txoParams;
    amplioParams m_amplioParams;
    daqParams m_daqParams;
    int m_daqDownloadingMode;

private slots:
    void initHardware();
    void runImage();
    void stopImage();
    void getTexoFirmwarePath();
    void getDaqFirmwarePath();
    void setCineSize();
    void selectProbe1();
    void selectProbe2();
    void cineScroll(int);
    void onApplyParams();
    void onSave();
    void onAmp(int);
    void onChannelDisplay(int);
};
