#pragma once

#include "ui_texo.h"

class TexoDemo : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    TexoDemo(QWidget* parent = 0);
    virtual ~TexoDemo();
    static int onData(void*, unsigned char*, int);

private:
    void setupControls();
    void readProbes();
    bool programSequence();
    bool programLookUpTable(int* o_numProgrammedLines);
    bool programSequenceFromLookUpTable();

private:
    int m_cineSize;
    int m_scanlines;
    int m_samplesPerLine;
    int m_display;
    int m_channels;
    bool m_transpose;

    QString m_dataPath;

private slots:
    void initHardware();
    void runImage();
    void stopImage();
    void getDataPath();
    void setCineSize();
    void selectProbe1();
    void selectProbe2();
    void selectProbe3();
    void cineScroll(int);
    void onApplyParams();
    void onSave();
    void onAmp(int);
    void onChannelDisplay(int);
};
