#pragma once

#include "qgraphicsview.h"

class TexoView : public QGraphicsView
{
public:
    TexoView(QWidget* parent = 0);
    virtual ~TexoView();

    bool init(int channels, int samples);
    void setAmp(int amp);
    void setChannelDisplay(int chd);
    void adjustScale();
    void display(char* data);

protected:
    virtual void drawForeground(QPainter* painter, const QRectF& r);
    virtual void resizeEvent(QResizeEvent*);

protected:

    int m_scanLines;
    int m_samples;
    int m_ssize;
    int m_amp;
    int m_display;
    double m_scale;
    char* m_buffer;
};
