#pragma once

#include "qgraphicsview.h"

class TexoViewImg : public QGraphicsView
{
public:
    TexoViewImg(QWidget* parent = 0);
    virtual ~TexoViewImg();

    bool init(int X, int Y, bool transpose = false);
    void setAmp(int amp);
    virtual bool setImgData(char* buffer);

protected:
    virtual void drawBackground(QPainter*, const QRectF&);
    virtual void resizeEvent(QResizeEvent*);

protected:
    void convertRF2Img(char* buffer, unsigned char* bufferImg);

protected:

    int m_width;
    int m_height;

    bool m_transpose;

    int m_amp;

    char* m_buffer;
    unsigned char* m_bufferImg;
    QImage* m_image;
};
