
#include "stdafx.h"
#include "UlteriusDemo.h"
#include "ui_ulterius.h"


#define MSG_TIMEOUT 3000     // ms
#define MAX_LIST    1024     // chars

char uList[MAX_LIST];
UlteriusDemo* mainWindow = 0;

// nice way to implement sleep since Qt typically requires setup of threads to use usleep(), etc.
void QSleep(int time)
{
    QMutex mtx;
    mtx.lock();
    QWaitCondition wc;
    wc.wait(&mtx, time);
}

// used to parse words from retreived lists
char* getWord(char* in, char sep, char* out, int sz)
{
    int pos = 0;

    strcpy_s(out, sz, "");

    while (in[pos] != sep)
    {
        if (in[pos] == '\0')
        {
            return 0;
        }

        out[pos] = in[pos];

        if (++pos >= sz)
        {
            return 0;
        }
    }

    out[pos] = '\0';

    return in + (pos + 1);
}

UlteriusDemo::UlteriusDemo(QWidget* parent) : QMainWindow(parent)
{
    setupUi(this);
    setupControls();

    //m_server = "localhost";
     m_server = "192.168.112.4"; //RP 192.168.1.125  CEP 10.162.34.118 Sonix Touch 192.168.1.130  127.0.0.1 117 localhost
	m_ulterius = new ulterius;

    m_ulterius->setCallback(onNewData);//NEW DATA FOR IMAGE. RETRIEVE 

    m_ulterius->setParamCallback(paramCallback);
    wStatus->showMessage(tr("Server address configured to: ") + m_server, MSG_TIMEOUT);

    mainWindow = this;
}

UlteriusDemo::~UlteriusDemo()
{
    if (m_ulterius)
    {
        m_ulterius->disconnect();
        delete m_ulterius;
    }
}

// setup various controls
void UlteriusDemo::setupControls()
{
    int i, j = 0;

    wModes->blockSignals(true);
    for (i = 0; i < wModes->count(); i++)
    {
        wModes->setItemData(i, BMode + i);
    }
    wModes->blockSignals(false);

    wParams->setColumnWidth(0, 120);
    wParams->setColumnWidth(1, 60);

    wAcquire->blockSignals(true);
    wAcquire->setColumnWidth(0, 120);
    wAcquire->setColumnWidth(1, 60);

    for (i = 0; i < wAcquire->rowCount(); i++)
    {
        j = (i > 10) ? 1 : 0;
        wAcquire->item(i, 0)->setData(Qt::UserRole, udtBPre << (i + j));
        wAcquire->item(i, 1)->setData(Qt::UserRole, udtBPre << (i + j));
    }

    wAcquire->blockSignals(false);
}

//Takes input image data (stored in qbr) and displays image on screen.
void UlteriusDemo::processFrame(const QByteArray& qbr, const int& type, const int& sz, const int& frmnum)
{
	
	int iwidth = 640;
	int iheight = 480;
	
	if(type == 16){
		iwidth = 400;
		iheight = sz/iwidth;
	}
	
	QImage frameImage;
	const unsigned char * uschardata = reinterpret_cast<const unsigned char*>(qbr.constData());

	switch (type)
	{
		case 2:
		case 4: // B 8
			{
				frameImage = QImage(uschardata,iwidth,iheight,QImage::Format_Indexed8);
				break;
			}
		case 8: // B 32
		case 1024: // color 32 bpp
		
			{
				frameImage = QImage(uschardata,iwidth,iheight,QImage::Format_RGB32);
				break;
			}
		case 16: // RF Beamformed
		case 512: // color RF
		case 2048: //  color V/V
			{
				frameImage = QImage(uschardata,iwidth,iheight,QImage::Format_Indexed8);
			}
		default:
			{
			}
	}// end switch
	frameImage.bits();
	
	mainWindow->labelDisplay->setPixmap(QPixmap::fromImage(frameImage));

}

//Rebeamforming algorithm. Uses precomputed delay tables rfdelays, and rfapts (with depth specified in max_samples)
//ns,nl - specify sample number and line number of RF data.
//Stores results in rf array.
//avgMode determines whether or not to do basic scan conversion.
int UlteriusDemo::pa_rebeamforming(const int ns, const int nl, int* postBF, int16_t* rf, int* rfdelays, int* rfapts, int max_samples, bool avgMode) {
	//int* postBF = new int[ns*nl];
	int* count = new int[ns*nl];

	for (int i = 0; i < ns*nl; i++) {
		postBF[i] = 0;
		count[i] = 1;
	}

	for (int r = 1; r <= nl; r++) {
		for (int j = 1; j <= ns; j++) {
			
			//double st_focus = (double)j / 2.0;
			//int half_apt = (((((double)j - st_focus)*(sampleSpacing * 1.0) / channelSpacing)) + 0.5) / 8;
			int half_apt = rfapts[j - 1];

			int imin = r - half_apt, imax = r + half_apt;
			if (imin < 1)
				imin = 1;
			if (imax > nl)
				imax = nl;

			for (int i = imin; i <= imax; i++) {
				int delay_pos = rfdelays[j-1 + abs(r-i)*max_samples];
					if (0 < delay_pos && delay_pos < ns) {
						postBF[j - 1 + (i - 1)*(ns)] = postBF[j - 1 + (i - 1)*(ns)] + (int)rf[delay_pos - 1 + (r - 1)*ns];
						count[j - 1 + (i - 1)*(ns)]++;
					}
			}
		}
	}

	double max = 0;
	if(avgMode){
		for(int i = 0; i < nl; i++)
			for(int j = 0; j< ns; j++)
				postBF[j+i*ns] = postBF[j+i*ns] / count[j+i*ns];
	} 
	else{
		for(int i = 0; i < nl; i++){
			for(int j = 0; j< ns; j++){
				postBF[j+i*ns] =  abs(postBF[j+i*ns] / count[j+i*ns]);
				if(j > 100 && j < (ns - 100) && (postBF[j+i*ns]) > max){
					max = postBF[j+i*ns];
				}
			}
		}
	}

	delete count;
	return max;
}

//Prints data to output file label.
//lines, samples, sz - specify the number of lines, samples, and bytes stored in data. 
void UlteriusDemo::printRfData(void *data, int lines, int samples, int sz, std::string label){
		int16_t* intdata = reinterpret_cast<int16_t*>(data);
		char* cdata = reinterpret_cast<char*>(data);

		std::cout << "Data output initialized. Size of char: "<< sizeof(char) <<" Size of int: "<< sizeof(int) << " Size of short: "<< sizeof(short) <<"\n";
		std::ofstream ofile(label + ".txt");
		std::ofstream rfile(label + "_raw.txt");
		
		for(int i = 0; i < sz; i++){
			rfile << cdata[i] << " " ;
		}

		for (int l = 0; l < lines; l++) {
			for (int s = 0; s < samples; s++) {
				ofile << intdata[s + l*samples] << ' ';

			}
			if(l != lines -1){
				ofile << '\n';
			}

		}
		ofile.close();
		rfile.close();
		//exit(0);
}

//Initialize PA beamforming delay tables.
//Input parameters include:
//speed of sound
//channelSpacing - spacing between transducer elements
//freq - frequency of sampling
//rf - input rf beamformed data.
//rfsamples - max number of anticipated samples per line.
void UlteriusDemo::initializeDelayTables(double soundSpeed, double channelSpacing, double freq, int* rfdelay, int* rfapt, int rfsamples){
	int line_num = 128;
		int sample_num = rfsamples;
		double sampleSpacing = 1 / freq * soundSpeed * 1000;
		for (int l = 0; l < line_num; l++)
			for (int s = 0; s < sample_num; s++) {
				double st_focus = (double)(s+1) / 2.0;

				double depth = ((double)s + 1.0 - st_focus)*(sampleSpacing);
				double width = ((double)l) * channelSpacing;
				double rad = sqrt((depth*depth) + width*width);
				double delay = st_focus + (rad) / (sampleSpacing);
				rfdelay[s + (l)*sample_num] = (delay + 0.5);
			}

		for (int s = 0; s < sample_num; s++) {
			double st_focus = (double)(s+1) / 2.0;
			rfapt[s] = (((((double)s + 1.0 - st_focus)*(sampleSpacing * 1.0) / channelSpacing)) + 0.5) / 8; /// 6;
		}
}

/*
void UlteriusDemo::scanConversion(int height, int width, int lines, int sample, uint8_t* finaldata, int*rfdata,int maxEle){
	for(int r = 0; r < height; r++)
			for(int c = 0; c < width; c++){
				double y = (double)r/(double)height * (double)sample;// + 0.5;
				double x = (double)c/(double)width * (double)lines;// + 0.5;
				int x1 = floor(x), y1 = floor(y);
				
				if (x1 < 0 || x1 >= lines - 1 || y1 < 0 || y1 >= sample - 1){
					finaldata[c + r*width] = 0;
					continue;
				}	
				int x2 = x1 + 1, y2 = y1 + 1;
				double xdist = x - x1, ydist = y - y1;
				double p1,p2,p3,p4, pt,pb; 			

				p1 = rfdata[x1*sample + y1];
				p2 = rfdata[x2*sample + y1];
				p3 = rfdata[x1*sample + y2];
				p4 = rfdata[x2*sample + y2];
				pt = p1*(1-xdist) + p2*xdist;
				pb = p3*(1-xdist) + p4*xdist;
				
				int fdata = (pt * (1.0 - ydist) + pb*ydist)/(maxEle/255) + 0.5;
				if(fdata > 255){
					fdata = 255;
				}
				finaldata[c+r*width] = (uint8_t)(fdata);
				//std::cout << "\nRESCALING\n";
			}
}*/

void UlteriusDemo::onSetAvg(bool mode){
	mainWindow->avgMode = mode;
}

void UlteriusDemo::onSetPrint(bool mode){
	mainWindow->printMode = mode;
}

//Process data acquired from SonixTouch here.
bool UlteriusDemo::onNewData(void* data, int type, int sz, bool cine, int frmnum)
{

    //Display frame rate if set to true.
	static bool dispFrameRate = true;

	//Adjust maximum number of samples for precomputed delay table. Increase if the number of samples per line
	//exceeds below value.
	static int rfsamples = 5000;

	static double soundSpeed = 1480.0;  //1540
	static double channelSpacing = 60.0 / 128.0; //0.1191 
	static double freq = 40 * 1000000;

	static std::string outputFile;

	//print_data = mainWindow->pushPrint->isChecked();
	

	static std::clock_t previous = std::clock();
	
	int lines = 128;
	int sample = sz/2/lines;
	
	if(dispFrameRate){
		double frames_sec = 1.0/((std::clock()-previous)/ (double)CLOCKS_PER_SEC);
		std::cout << "\nSample Depth: "<< sample <<" . Frame rate = " << frames_sec << "Hz\n";
		previous = std::clock();
	}
	
	//static bool averageMode = false;
	static bool initialize = true;
	static int avgSample = 0;
	static int avgNum = 1;
	static int frameNum = 0;
	static int* avgData = new int[lines*sample]; 

	//averageMode = mainWindow->enableAvg->isChecked();
	if(mainWindow->avgMode){
		//int value = mainWindow->averageNum->value();
		std::cout << "\nAveraging " << avgNum << " frames\n";
	}
	
	static int* rfdelay = new int[128 * rfsamples];
	static int* rfapt = new int[rfsamples];
	
	if (initialize) {
		initialize = false;
		mainWindow->printMode = false;
		mainWindow->avgMode = false;
		initializeDelayTables(soundSpeed, channelSpacing, freq, rfdelay, rfapt, rfsamples);
	}


	//Print Rf data to file.
	if(type == 16 && mainWindow->printMode){
		//print_data = false;
		mainWindow->printMode = false;
		mainWindow->pushPrint->setChecked(false);
		outputFile = mainWindow->dataTitle->text().toStdString() ;
		printRfData(data, lines, sample, sz, outputFile);
	}
	




	//bool processRF = true;
	if(type == 16 ){ //&& processRF){
		int16_t* intdata = reinterpret_cast<int16_t*>(data);
		int* rfdata = new int[sample*lines];
		int maxEle = pa_rebeamforming(sample, lines,rfdata, intdata, rfdelay, rfapt, rfsamples,mainWindow->avgMode);

		if(mainWindow->avgMode){
			if(avgSample != sample){
				frameNum = 0;
				//avgNum = mainWindow->averageNum->value();
				avgSample = sample;
				
				delete avgData;
				avgData = new int[sample*lines];
			}

			frameNum++;

			if(frameNum == 1){
				avgNum = mainWindow->averageNum->value();
				for(int i = 0; i < sample*lines; i++)
					avgData[i] = rfdata[i]/avgNum;
			}
			else
				for(int i = 0; i < sample*lines; i++)
					avgData[i] += rfdata[i]/avgNum;


			if(frameNum != avgNum)
				return true;
			else{
				maxEle = 0;
				frameNum = 0;
				for(int i = 0; i < lines; i++){
					for(int j = 0; j< sample; j++){
						rfdata[j+i*sample] = abs(avgData[j+i*sample]);
						if(j > 100 && j < (sample - 100) && (rfdata[j+i*sample]) > maxEle){
							maxEle = rfdata[j+i*sample];
						}
					}
				}
			}
		}
		//std::cout << "\nRF PROCESSING COMPLETE \n";
		
		double eachsampledepth = 1/(40e6)*1490*1000;
		double sampledepth = eachsampledepth * sample;
		int width = 400, height = width/60*sampledepth;
		sz = width*height;

		uint8_t* finaldata = new uint8_t[sz];
		//scanConversion(height, width, lines, sample, finaldata, rfdata, maxEle);
		
		for(int r = 0; r < height; r++)
			for(int c = 0; c < width; c++){
				double y = (double)r/(double)height * (double)sample;// + 0.5;
				double x = (double)c/(double)width * (double)lines;// + 0.5;
				int x1 = floor(x), y1 = floor(y);
				
				if (x1 < 0 || x1 >= lines - 1 || y1 < 0 || y1 >= sample - 1){
					finaldata[c + r*width] = 0;
					continue;
				}	
				int x2 = x1 + 1, y2 = y1 + 1;
				double xdist = x - x1, ydist = y - y1;
				double p1,p2,p3,p4, pt,pb; 			

				p1 = rfdata[x1*sample + y1];
				p2 = rfdata[x2*sample + y1];
				p3 = rfdata[x1*sample + y2];
				p4 = rfdata[x2*sample + y2];
				pt = p1*(1-xdist) + p2*xdist;
				pb = p3*(1-xdist) + p4*xdist;
				
				int fdata = (pt * (1.0 - ydist) + pb*ydist)/(maxEle/255) + 0.5;
				if(fdata > 255){
					fdata = 255;
				}
				finaldata[c+r*width] = (uint8_t)(fdata);
				//std::cout << "\nRESCALING\n";
			}

		QByteArray qbr(reinterpret_cast<const char*>(finaldata),sz);
		QMetaObject::invokeMethod(mainWindow, "processFrame", Qt::QueuedConnection, Q_ARG(QByteArray, qbr),Q_ARG(int, type), Q_ARG(int, sz),Q_ARG(int, frmnum));
		delete finaldata;
		delete rfdata;
		return true;
	}
	
	QByteArray qbr(reinterpret_cast<const char*>(data),sz);
	QMetaObject::invokeMethod(mainWindow, "processFrame", Qt::QueuedConnection, Q_ARG(QByteArray, qbr),Q_ARG(int, type), Q_ARG(int, sz),Q_ARG(int, frmnum));
    return true;
}


// parameter was changed, update interface
bool UlteriusDemo::paramCallback(void*, int, int)
{
    /*char* id = (char*)paramID;
       QString text(id);
       text.append(" changed");
       mainWindow->wStatus->showMessage(text, MSG_TIMEOUT);*/

    return true;
}

// allow user to configure server name
void UlteriusDemo::onServerAddress()
{
    bool ok = false;
    QString text = QInputDialog::getText(this, tr("Enter Server Address"), tr("Server Address:"), QLineEdit::Normal, m_server, &ok);

    if (ok && !text.isEmpty())
    {
        m_server = text;
    }
}

// user connected/disconnected
void UlteriusDemo::onConnect(bool state)
{
    int i, j, val = 0;
    QTableWidgetItem* item;

    if (state)
    {
        if (m_ulterius->connect(m_server.toAscii()))
        {
            wStatus->showMessage(tr("Successfully made connection"), MSG_TIMEOUT);
            onRefresh();
        }
        else
        {
            wStatus->showMessage(tr("Could not connect to specified server address"), MSG_TIMEOUT);
            aConnect->setChecked(false);
        }
    }
    else
    {
        if (m_ulterius->disconnect())
        {
            wStatus->showMessage(tr("Disconnected"), MSG_TIMEOUT);
        }

        aConnect->setChecked(false);
    }

    if (m_ulterius->isConnected())
    {
        // load parameters list
        uParam prm;
        i = j = 0;

        wParams->blockSignals(true);
        while (m_ulterius->getParam(i, prm))
        {
            if (prm.source == 1)
            {
                wParams->setRowCount(wParams->rowCount() + 1);
                item = new QTableWidgetItem(prm.name);
                item->setFlags(Qt::ItemIsEnabled | Qt::ItemIsSelectable);
                item->setData(Qt::UserRole, prm.id);
                wParams->setItem(j, 0, item);

                val = 0;
                m_ulterius->getParamValue(prm.id, val);
                item = new QTableWidgetItem(QString("%1").arg(val));
                item->setFlags(Qt::ItemIsEnabled | Qt::ItemIsSelectable | Qt::ItemIsEditable);
                item->setData(Qt::UserRole, prm.id);
                wParams->setItem(j, 1, item);
                j++;
            }
            i++;
        }
        wParams->blockSignals(false);
    }
}

// user toggled freeze
void UlteriusDemo::onFreeze(bool)
{
    m_ulterius->toggleFreeze();

    QSleep(500);

    aFreeze->blockSignals(true);
    aFreeze->setChecked(m_ulterius->getFreezeState() != 0);
    aFreeze->blockSignals(false);
}

// user selected first probe
void UlteriusDemo::onProbe1()
{
    m_ulterius->selectProbe(0);
    onRefresh();
}

// user selected second probe
void UlteriusDemo::onProbe2()
{
    m_ulterius->selectProbe(1);
    onRefresh();
}

// user selected third probe
void UlteriusDemo::onProbe3()
{
    m_ulterius->selectProbe(2);
    onRefresh();
}

// user changed modes
void UlteriusDemo::onSelectMode(int index)
{
    if (m_ulterius->selectMode(wModes->itemData(index).toInt()))
    {
        wStatus->showMessage(tr("Successfully changed modes"), MSG_TIMEOUT);
    }
}

// user changed presets
void UlteriusDemo::onSelectPreset(QString preset)
{
    if (m_ulterius->selectPreset(preset.toAscii()))
    {
        wStatus->showMessage(tr("Successfully changed presets"), MSG_TIMEOUT);
    }
}

// user selected a new parameter
void UlteriusDemo::onSelectParam()
{
    refreshParamValue();
}

// user incremented parameter
void UlteriusDemo::onIncParam()
{
    if (!wParams->currentItem())
    {
        return;
    }

    QString prm = wParams->currentItem()->data(Qt::UserRole).toString();
    if (m_ulterius->incParam(prm.toAscii()))
    {
        refreshParamValue();
    }
}

// user decremented parameter
void UlteriusDemo::onDecParam()
{
    if (!wParams->currentItem())
    {
        return;
    }

    QString prm = wParams->currentItem()->data(Qt::UserRole).toString();
    if (m_ulterius->decParam(prm.toAscii()))
    {
        refreshParamValue();
    }
}

// refreshes the currently selected parameter value
void UlteriusDemo::refreshParamValue()
{
    if (!wParams->currentItem())
    {
        return;
    }

    int val;
    QString prm = wParams->currentItem()->data(Qt::UserRole).toString();

    if (m_ulterius->getParamValue(prm.toAscii(), val))
    {
        wParams->item(wParams->currentRow(), 1)->setText(QString("%1").arg(val));
    }
}

// user changed the acquisition boxes
void UlteriusDemo::onDataClicked(int, int)
{
    int i, mask = 0;
    QTableWidgetItem* item;
    for (i = 0; i < wAcquire->rowCount(); i++)
    {
        item = wAcquire->item(i, 0);
        mask |= (item->checkState() == Qt::Checked) ? item->data(Qt::UserRole).toInt() : 0;
    }

    m_ulterius->setDataToAcquire(mask);
}

// user toggled shared memory mode
void UlteriusDemo::onSharedMemoryToggle(bool state)
{
    m_ulterius->setSharedMemoryStatus(state ? 1 : 0);
}

// user toggled inject mode
void UlteriusDemo::onInjectToggle(bool)
{
    m_ulterius->setInjectMode(m_ulterius->getInjectMode() ? false : true);

    QSleep(500);

    aInjectToggle->blockSignals(true);
    aInjectToggle->setChecked(m_ulterius->getInjectMode() != 0);
    aInjectToggle->blockSignals(false);
}

// injects random data
void UlteriusDemo::onInjectRandom()
{
    uDataDesc desc;
    unsigned char* data = 0;
    int i, sz;

    if (m_ulterius->getDataDescriptor(udtBPost, desc))
    {
        sz = desc.w * desc.h * (desc.ss / 8);
        data = (unsigned char*)malloc(sz);

        if (data)
        {
            for (i = 0; i < sz; i++)
            {
                data[i] = (unsigned char)(rand() % 255);
            }

            m_ulterius->injectImage(data, desc.w, desc.h, desc.ss, false);

            free(data);
        }
    }
}

// refresh the interface
void UlteriusDemo::onRefresh()
{
    int i, sel;
    char* pStr;
    char str[256];
    QString curMode, curProbe, curPreset;

    wPresets->clear();

    // load probes
    if (m_ulterius->getProbes(uList, MAX_LIST))
    {
        i = 0;
        pStr = uList;
        while ((pStr = getWord(pStr, '\n', str, 256)) != 0)
        {
            switch (i++)
            {
            case 0: wProbe1->setText(str);
                break;
            case 1: wProbe2->setText(str);
                break;
            case 2: wProbe3->setText(str);
                break;
            }
        }
    }

    // load presets
    if (m_ulterius->getPresets(uList, MAX_LIST))
    {
        pStr = uList;
        while ((pStr = getWord(pStr, '\n', str, 256)) != 0)
        {
            wPresets->addItem(str);
        }

        wPresets->setCurrentIndex(0);
    }

    // get current mode
    sel = m_ulterius->getActiveImagingMode();
    if (sel != -1)
    {
        for (i = 0; i < wModes->count(); i++)
        {
            if (wModes->itemData(i) == sel)
            {
                curMode = QString("Mode=%1, ").arg(wModes->itemText(i));
                break;
            }
        }
    }

    // get current probe
    if (m_ulterius->getActiveProbe(str, 256))
    {
        curProbe = QString("Probe=%1, ").arg(str);
    }

    // get current preset
    if (m_ulterius->getActivePreset(str, 256))
    {
        curPreset = QString("Preset=%1").arg(str);
    }

    wStatus->showMessage(curMode + curProbe + curPreset, MSG_TIMEOUT);
}
