#pragma once

#include "ui_ulterius.h"
#include <iostream>
#include <fstream>
#include <cstdint>
#include <math.h> 

#include <string>
#include <ctime>

class ulterius;
class porta;

class UlteriusDemo : public QMainWindow, private Ui::MainWindow
{
    Q_OBJECT

public:
    UlteriusDemo(QWidget* parent = 0);
    virtual ~UlteriusDemo();

public slots:
	void processFrame(const QByteArray& qbr, const int& type, const int& sz, const int& frmnum);

private:
    void setupControls();
    void refreshParamValue();
	static void printRfData(void *data, int lines, int samples, int sz, std::string label);
	static int pa_rebeamforming(const int ns, const int nl, int* postBF, int16_t* rf, int* rfdelays, int* rfapts, int max_samples, bool avgMode); 
    static void initializeDelayTables(double soundSpeed, double channelSpacing, double freq, int* rfdelay, int* rfapt, int rfsamples);
	//static void scanConversion(int height, int width, int lines, int sample, uint8_t* finaldata, int*rfdata,int maxEle);

	static bool paramCallback(void* paramID, int x, int y);
    static bool onNewData(void* data, int type, int sz, bool cine, int frmnum);


private:
	bool printMode;
	bool avgMode;
    QString m_server;
    ulterius* m_ulterius;

private slots:
    void onServerAddress();
    void onConnect(bool);
    void onFreeze(bool);
    void onRefresh();
    void onProbe1();
    void onProbe2();
    void onProbe3();
    void onSelectMode(int);
    void onSelectPreset(QString);
    void onSelectParam();
    void onIncParam();
    void onDecParam();
    void onDataClicked(int, int);
    void onSharedMemoryToggle(bool);
    void onInjectToggle(bool);
    void onInjectRandom();
	void onSetPrint(bool);
	void onSetAvg(bool);
};
