#pragma once

////////////////////////////////////////////////////////////////////////////////
/// Callback for when a non-blocking function has completed
////////////////////////////////////////////////////////////////////////////////
typedef bool (*ULTERIUS_CALLBACK)(void* data, int type, int sz, bool cine, int frmnum);
typedef bool (*ULTERIUS_PARAM_CALLBACK)(void* paramID, int ptX, int ptY);


#ifdef ULTRASONIX_INTERNAL_BUILD
    #include "../../utx_utils/uDataDesc.h"
    #include "../../utx_utils/uFileHeader.h"
#else
    #include "../../global/uDataDesc.h"
    #include "../../global/uFileHeader.h"
#endif


////////////////////////////////////////////////////////////////////////////////
/// Ulterius parameter definition.
////////////////////////////////////////////////////////////////////////////////
class uParam
{
public:
    /// unique identifier
    char id[80];
    /// parameter name
    char name[80];
    /// parameter type
    int type;
    /// parameter unit
    int unit;
    /// source
    int source;
};

////////////////////////////////////////////////////////////////////////////////
/// Ulterius rectangle definition.
////////////////////////////////////////////////////////////////////////////////
class uRect
{
public:
    /// Left coordinate
    int left;
    /// Top coordinate
    int top;
    /// Right coordinate
    int right;
    /// Bottom coordinate
    int bottom;
};

////////////////////////////////////////////////////////////////////////////////
/// Ulterius curve definition.
////////////////////////////////////////////////////////////////////////////////
class uCurve
{
public:
    /// horizontal position of top point
    int t;
    /// horizontal position of middle point
    int m;
    /// horizontal position of bottom point
    int b;
    /// vertical position of middle point
    int vm;
};

////////////////////////////////////////////////////////////////////////////////
/// Ulterius TGC definition.
////////////////////////////////////////////////////////////////////////////////
class uTGC
{
public:
    /// First TGC slider value
    int v1;
    /// Second TGC slider value
    int v2;
    /// Third TGC slider value
    int v3;
    /// Fourth TGC slider value
    int v4;
    /// Fifth TGC slider value
    int v5;
    /// Sixth TGC slider value
    int v6;
    /// Seventh TGC slider value
    int v7;
    /// Eighth TGC slider value
    int v8;
};

////////////////////////////////////////////////////////////////////////////////
/// Ulterius point definition.
////////////////////////////////////////////////////////////////////////////////
class uPoint
{
public:
    /// x coordinate
    int x;
    /// y coordinate
    int y;
};

enum uVariableType
{
    uTypeInteger = 0,
    uTypeFloat = 1,
    uTypeString = 2,
    uTypeGainCurve = 3,
    uTypeRectangle = 4,
    uTypeCurve = 5,
    uTypeColor = 6,
    uTypeBoolean = 7,
    uTypeDontKnow = 8,
    uTypePoint = 9
};
