%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Author: Christopher Hunt <chunt11@jhu.edu>
%         Matthew Walmer <mwalmer3@jhu.edu>
% Date: 24 April 2016
% Description: Performs hand-eye calibration of a single robot using
%              ARToolKit marker data
%
% Input:    robot_data_m_filename -> name of m file containing robot pose
%                                    data and marker pose data
% Output:   gHe -> The transformation from the camera space to the 
%                  gripper
%           err -> The error associated with the calibration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [ gHc, err ] = ATK_calibrate_handeye( robot_data_m_filename )
    %% Load and reformat end-effector pose data and generate file names
    disp( 'Loading and parsing calibration data...' );
    load( robot_data_m_filename ); %loads bHg and cHm
    %process into 3-dim matrix
    n = size(bHg,1);
    bHg_m = zeros(4,4,n);
    cHm_m = zeros(4,4,n);
    for i=1:n
        bHg_m(:,:,i) = bHg{i};
        cHm_m(:,:,i) = cHm{i};
    end
    
    %% Hand Eye Calibration
    disp( 'Generating the homogenous transformation...' );
    [ gHc, err ] = tsai_calibration( bHg_m, cHm_m );
 
end