%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Author: Matthew Walmer <mwalmer3@jhu.edu>
% Date: 28 April 2016
% Description: Script to perform ARToolKit robot-robot calibration
%
% Input Data File Formats:
%   (Robot)_data_m_file contents:
%       bHg -> n x 1 cell, each containing a 4x4 homogenous transformation
%              matrix representing a robot gripper to base frame transf.
%       cHm -> n x 1 cell, each containing a 4x4 homogenous transformation
%              matrix representing a marker frame to camera frame transf.
%   (Robot)_handeye:           
%       gHc -> 4 x 4 homogenous transformation matrix from the camera
%              frame to the gripper frame.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear; clc; addpath('util')

% SETTINGS
plot_diagram      = true;
Jerry_data_m_file = 'data/ATK_Hiro_Jerry_16_04_26.mat';
Jerry_handeye     = 'data/ATK_Hiro_handeye_jerry_16_04_26.mat';
Dash_data_m_file  = 'data/ATK_Hiro_Dash_16_04_26.mat';
Dash_handeye      = 'data/ATK_Hiro_handeye_dash_16_04_26.mat';

% COMPUTE MARKER POSES
[ b1Hm, J_V, J_SD, J_poses ] = ATK_get_marker_pose(Jerry_data_m_file, Jerry_handeye);
[ b2Hm, D_V, D_SD, D_poses ] = ATK_get_marker_pose(Dash_data_m_file, Dash_handeye);

% COMPUTE TRANSFORMATION
b1Hb2 = b1Hm * inv( b2Hm );

%% plot marker points
if plot_diagram
    Draw_Bots(b1Hb2);
    n = size(J_poses,3);
    for i = 1:n
        plot3(J_poses(1,4,i),J_poses(2,4,i),J_poses(3,4,i),'bo')
        temp = b1Hb2 * D_poses(:,4,i);
        plot3(temp(1),temp(2),temp(3),'ro')
    end
end