%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Author: Matthew Walmer <mwalmer3@jhu.edu>
% Date: 28 April 2016
% Description: Script to process raw data for ARToolKit calibration and
%              write to a .m file.
%
% Input Data File Format:
%   pose_xlsx_filename -> Excel file containing robot pose data. Each
%                         row is a pose of the robot end-effector in the
%                         robot base frame, encoded by 3 translational
%                         componets and 3 euler angles formatted:
%                         X Y Z A B C
% Additional Instruction:
%   Paste data of marker poses with respect to camera frame (cHm) in the
%   section indicated below.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% SETTINGS
pose_xlsx_filename = 'rawdata/ATK_3corner_Dash_16_04_28.xlsx';
output_filename = 'data/ATK_3corner_Dash_16_04_28.mat';

% EXCEL PROCESSING
x = xlsread(pose_xlsx_filename);
n = size(x,1);
bHg = cell(n,1);
for i = 1:n
    H = x(i,:);
    Rj = eul2rotm(H(1,4:6) * pi/180);
    tj = (H(1,1:3))';
    bHg{i} = [Rj tj; 0 0 0 1];
end
    
% PASTE MARKER POSES
cHm = cell(n,1);
%cHm{} = 

cHm{1} = [ 0.624263, -0.043864, 0.779982, 38.967635;
 -0.575991, -0.700341, 0.421612, 48.262177;
 0.527760, -0.712459, -0.462462, 363.512872;
 0, 0, 0, 1 ];

cHm{2} = [ 0.627136, -0.049632, 0.777327, 46.258283;
 -0.424506, -0.858511, 0.287670, 33.299923;
 0.653066, -0.510388, -0.559472, 278.269600;
 0, 0, 0, 1 ];

cHm{3} = [ 0.513719, 0.035748, 0.857213, 63.056252;
 -0.435196, -0.850195, 0.296264, 29.507202;
 0.739390, -0.525252, -0.421204, 292.635743;
 0, 0, 0, 1 ];

cHm{4} = [ 0.394733, -0.204926, 0.895651, 52.795265;
 -0.555353, -0.829801, 0.054897, 15.613004;
 0.731963, -0.519072, -0.441356, 221.889454;
 0, 0, 0, 1 ];

cHm{5} = [ 0.398914, -0.206596, 0.893412, 52.099903;
 -0.439089, -0.898368, -0.011686, -16.920642;
 0.805027, -0.387626, -0.449086, 327.739532;
 0, 0, 0, 1 ];

cHm{6} = [ 0.582769, -0.285655, 0.760777, -0.341055;
 -0.417293, -0.908518, -0.021475, 1.932928;
 0.697314, -0.304952, -0.648658, 242.746185;
 0, 0, 0, 1 ];

cHm{7} = [ 0.216039, -0.821757, 0.527297, 16.724395;
 -0.848458, -0.425246, -0.315096, 9.378580;
 0.483163, -0.379316, -0.789096, 234.280336;
 0, 0, 0, 1 ];

cHm{8} = [ 0.645252, -0.441238, 0.623666, 53.046116;
 -0.669068, -0.720441, 0.182519, 37.743984;
 0.368780, -0.535046, -0.760084, 331.485197;
 0, 0, 0, 1 ];

cHm{9} = [ 0.521308, -0.478037, 0.706907, 30.087883;
 -0.807115, -0.545212, 0.226514, -7.979008;
 0.277132, -0.688639, -0.670055, 327.593339;
 0, 0, 0, 1 ];

cHm{10} = [ 0.763779, 0.419425, 0.490637, 54.278914;
 0.060819, -0.803494, 0.592197, 56.498549;
 0.642607, -0.422468, -0.639201, 255.824561;
 0, 0, 0, 1 ];

% SAVE TO FILE
save(output_filename,'bHg','cHm')
