%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Author: Christopher Hunt <chunt11@jhu.edu>
% Date: 4 May 2016
% Description: Returns the approximate border indices of an image surrounded
%              by black borders 
%              (i.e. I( y_low:y_high, x_low:x_high ) returns the cropped image with no black borders)
% Input: I        -> the image matrix
% Output: borders -> The border indices [ x_low; x_high; y_low; y_high ]
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function borders = mask_image( I )
    [ N, M, ~ ] = size( I );

    x_low = 1;
    x_high = M;

    y_low = 1;
    y_high = N;

    % top
    c = I( y_high, M / 2 ); % top middle
    while sum( c ) == 0
        y_high = y_high - 1;
        c = I( y_high, M / 2 );
    end

    % bottom
    c = I( y_low, M / 2 ); % bottom middle
    while sum( c ) == 0
        y_low = y_low + 1;
        c = I( y_low, M / 2 );
    end

    % left
    c = I( N / 2, x_low ); % left middle
    while sum( c ) == 0
        x_low = x_low + 1;
        c = I( N / 2, x_low );
    end

    % right
    c = I( N / 2, x_high );
    while sum( c ) == 0
        x_high = x_high - 1;
        c = I( N / 2, x_high );
    end

    borders = uint16([ x_low; x_high; y_low; y_high ]);
end