%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Author: Matthew Walmer <mwalmer3@jhu.edu>
% Date: 28 April 2016
% Description: Script to perform ARToolKit handeye calibration
%
% Input Data File Formats:
%   (Robot)_data_m_file contents:
%       bHg -> n x 1 cell, each containing a 4x4 homogenous transformation
%              matrix representing a robot gripper to base frame transf.
%       cHm -> n x 1 cell, each containing a 4x4 homogenous transformation
%              matrix representing a marker frame to camera frame transf.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addpath('util')

% INPUT FILENAMES
datafile_jerry = 'data/ATK_3corner_Jerry_16_04_28.mat';
datafile_dash  = 'data/ATK_3corner_Dash_16_04_28.mat';

% OUTPUT FILENAMES
outfile_jerry  = 'data/ATK_3corner_handeye_jerry_16_04_28.mat';
outfile_dash   = 'data/ATK_3corner_handeye_dash_16_04_28.mat';

%%
[ ATK_g1Hc1, ATK_err1 ] = ATK_calibrate_handeye( datafile_jerry );
[ ATK_g2Hc2, ATK_err2 ] = ATK_calibrate_handeye( datafile_dash );

gHc = ATK_g1Hc1;
save( outfile_jerry, 'gHc' )
gHc = ATK_g2Hc2;
save( outfile_dash, 'gHc' )