%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Author: Christopher Hunt <chunt11@jhu.edu>
%         Matthew Walmer <mwalmer3@jhu.edu>
% Date: 31 March 2016
% Description: Script to perform checkerboard calibration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% dependencies

addpath( strcat( pwd, '/util' ) );

%% global variables, change these for a different calibration set

dashFiles = strcat( pwd, '/Checkerboard Calibration/16-03-25-only-10/Dash' ); % path to Dash calibration files
jerryFiles = strcat( pwd, '/Checkerboard Calibration/16-03-25-only-10/Jerry' ); % path to Jerry calibration files
sq_size = 30; % size of one side of a square of the calibration checkerboard (in mm)
           
%% perform hand-eye calibrations using tsai's algorithm

disp( 'Hand eye calibration for Jerry...' );
[ g1Hc1, g1Hc1_err, b1Hw, b1Hw_dev ] = calibrate_handeye( jerryFiles, sq_size );
disp( 'Hand eye calibration for Dash...' );
[ g2Hc2, g2Hc2_err, b2Hw, b2Hw_dev ] = calibrate_handeye( dashFiles, sq_size );

%% compute the homogenous transform

b1Hb2 = b1Hw * inv(b2Hw);