%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Author: Matthew Walmer <mwalmer3@jhu.edu>
% Date: 1 April 2016
% Description: Draws a 3D diagram of the robots based on H, the homogenous
%              robot to robot transformation matrix (b1Hb2).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function Draw_Bots( H, fig_num )

if nargin < 2
    fig_num = 1;
end

bc = [638;0;0];%board center (approximated)

figure(fig_num)
clf
hold on

%board
cor1 = bc + [3.5*30;4*30;15];
cor2 = bc + [-3.5*30;4*30;15];
cor3 = bc + [-3.5*30;-4*30;15];
cor4 = bc + [3.5*30;-4*30;15];
plot3([cor1(1) cor2(1)],[cor1(2) cor2(2)],[cor1(3) cor2(3)],'b');
hold on
daspect([1 1 1])
view(-10, 10);
plot3([cor2(1) cor3(1)],[cor2(2) cor3(2)],[cor2(3) cor3(3)],'r');
plot3([cor3(1) cor4(1)],[cor3(2) cor4(2)],[cor3(3) cor4(3)],'g');
plot3([cor4(1) cor1(1)],[cor4(2) cor1(2)],[cor4(3) cor1(3)],'m');
%board dimensions: 8 squares wide, 7 squares tall, each square 30mm
%orig = [bc(1)-(2.5*30);bc(2)-(3*30);bc(3)];
%plot3(orig(1),orig(2),orig(3),'k+')

%workspace
cor1 = [300;-300;15];
cor2 = [300;300;15];
cor3 = [900;300;15];
cor4 = [900;-300;15];
plot3([cor1(1) cor2(1)],[cor1(2) cor2(2)],[cor1(3) cor2(3)],'k');
plot3([cor2(1) cor3(1)],[cor2(2) cor3(2)],[cor2(3) cor3(3)],'k');
plot3([cor3(1) cor4(1)],[cor3(2) cor4(2)],[cor3(3) cor4(3)],'k');
plot3([cor4(1) cor1(1)],[cor4(2) cor1(2)],[cor4(3) cor1(3)],'k');

%jerry
plot3(0,0,0,'kd')
plot3([0 -100],[0 0],[0 400],'k');
plot3([-100 100],[0 0],[400 600],'k');
plot3([100 350],[0 0],[600 550],'k');
plot3(350,0,550,'kd')
%text(0,0,200,'Jerry')

%dash
db = [H(1,4);H(2,4);H(3,4)];%dash base
plot3(db(1),db(2),db(3),'k*')
plot3([db(1)     db(1)+100],[db(2) db(2)],[db(3)     db(3)+400],'k');
plot3([db(1)+100 db(1)-100],[db(2) db(2)],[db(3)+400 db(3)+600],'k');
plot3([db(1)-100 db(1)-350],[db(2) db(2)],[db(3)+600 db(3)+550],'k');
plot3(db(1)-350,db(2),db(3)+550,'k*')
%text(db(1),db(2),db(3)+200,'Dash')

axis vis3d

end

