function S = skew(s)

% returns a skew-symmetric MxM matrix

% S = zeros( M );
% for i = 1:M
%     for j = 1:M
%         if i > j % bottom left
%             S( i, j ) = s( M - i )
%         else % top right
%         end
%     end
% end

  if 3 ~= size(s,1),
    error('vector must be 3x1')
  end

S = [   0   -s(3)   s(2);
      s(3)   0     -s(1);
     -s(2)   s(1)     0 ];