#include <ADC.h>

// These constants won't change:
// Buttons
const int button1 = 24;
const int button2 = 27;
const int sensorPin = A0;    // pin that the sensor is attached to
const int sensorPin2 = A20;
const int ledPin_adc = 8;        // pin that the LED is attached to

// variables:
int sensorMin = 1023;        // minimum sensor value
int sensorMax = 0;           // maximum sensor value

unsigned long j;
unsigned long startTime;
int adcReading;
unsigned long duration = 1000; // 1 sec
const unsigned long bufferAmt = 25000;
int bufferPacket[bufferAmt];

bool buttonSelect;
bool isCollecting;
bool isPressing;

ADC *adc = new ADC();

void setup()
{  
  pinMode(LED_BUILTIN,OUTPUT);    // LED
  digitalWrite(LED_BUILTIN,LOW);  // LED off
  pinMode(ledPin_adc,OUTPUT);    // LED
  digitalWrite(ledPin_adc,LOW);    // LED off
  
  // internal resistor enable for 
  pinMode(button1,INPUT_PULLUP);       // Control for Send/Receive select
  pinMode(button2,INPUT_PULLUP);       // Control for address
  pinMode(sensorPin,INPUT);
  pinMode(sensorPin2,INPUT);
  
  //8,10,12,16
  adc->setResolution(16);
  //0,4,8,16,32
  adc->setAveraging(8);
  adc->setSamplingSpeed(ADC_MED_SPEED);
  adc->setConversionSpeed(ADC_MED_SPEED);

  buttonSelect = false;
  isCollecting = false;
  isPressing = true;

  Serial.begin(115200);
  delay(100);
  j = 0;
}

void loop() {
  if(digitalRead(button1) == HIGH && digitalRead(button2) == HIGH && isPressing == true){
    digitalWrite(LED_BUILTIN,HIGH);  // LED off
    isPressing = false;
  }
  if(!isPressing){
    if(digitalRead(button1) == LOW){
      digitalWrite(LED_BUILTIN,LOW);  // LED on
      isPressing = true;
      buttonSelect = !buttonSelect;
      Serial.print("Channel state switched: \n");
      if(buttonSelect)
      Serial.println("Set to A0");
      else
      Serial.println("Set to A20");
    }
    if(digitalRead(button2) == LOW && isCollecting == false){
      digitalWrite(LED_BUILTIN,LOW);  // LED on
      isPressing = true;
      isCollecting = true;
      delay(400);
      startTime = millis();
      digitalWrite(ledPin_adc,HIGH);    // LED off
      Serial.print("ADC data being collected. \n");
    }
  }
  if(isCollecting){
    collectADCData();
    j = j + 1;
    if(millis() > (startTime + duration) || j == bufferAmt){
      isCollecting = false;
      unsigned long elapsed = millis() - startTime;
      Serial.println("ADC data collection done.");
      if (j == bufferAmt){
        Serial.println("Buffer has been filled.");
      }
      j = 0;
      Serial.printf("The sampling time was %d ms. \n",elapsed);
      digitalWrite(ledPin_adc,LOW);    // LED off
      dispADCData();
    }
  }
}

void collectADCData(){
  if(buttonSelect){
    adcReading = adc->analogRead(sensorPin);
  } else {
    adcReading = adc->analogRead(sensorPin2);
  }
  bufferPacket[j] = adcReading;
}

void dispADCData(){
  for (unsigned long k=0;k<bufferAmt;k++){
    String msg = "0 ";
    msg += bufferPacket[k];
    msg += " 70000";
    Serial.println(msg);
    delayMicroseconds(1000);
  }
}

