%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Analyzes images of phantoms
% overdrilledP - overdrilling percentage
% score - underdrilling quantification
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
% provide image to analyze
I=imread('vf2.jpg');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Frame
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% normalize image intensity based on mean pixel value of red frame
[frame,~]=colorfilter(I,[300,15]);
bg=mean(frame(frame~=0));
test=0.5085; % test phantom as baseline
scale=bg/test;
I=I/scale;
% extract red frame
[frame,frameBW]=colorfilter(I,[300,15]);
% find 3 post holes in frame
[centers, radii]=imfindcircles(frame,[10 30],'ObjectPolarity','dark',...
    'Sensitivity',0.9);
% sort circles by x+y coordinate value
[~, index] = sort(centers(:,1)+centers(:,2));
centers = centers(index, :);
radii = radii(index, :);
% align phantom frame with image frame
p1=centers(1,:);
p2=centers(2,:);
p3=centers(3,:);
p12=p2-p1;
p3=[1000,p1(2)];
p13=p3-p1;
ang = acosd(dot(p12,p13)/sqrt(sum(p12.^2)*sum(p13.^2)));
frame=imrotate(frame,ang-90);
frameBW=imrotate(frameBW,ang-90);
imshow(frame)
hold on
% find 3 post holes in frame
[centers, radii]=imfindcircles(frame,[10 30],'ObjectPolarity','dark',...
    'Sensitivity',0.9);
% sort circles by x+y coordinate value
[~, index] = sort(centers(:,1)+centers(:,2));
centers = centers(index, :);
radii = radii(index, :);
% add post holes to image
h=viscircles(centers,radii,'Color','g');
p1=centers(1,:);
p2=centers(2,:);
p3=centers(3,:);
% draw two lines connecting the circles
plot([p1(1),p2(1)],[p1(2),p2(2)],'Color','w','LineWidth',2)
plot([p2(1),p3(1)],[p2(2),p3(2)],'Color','w','LineWidth',2)
hold off

% define bottom left fiducial point as reference
X=[p1;p2];
d = pdist(X,'euclidean');
fixed=822;
% locate round window
center=[centers(2,1)+250*d/fixed,centers(2,2)-320*d/fixed];
radius=10*d/fixed;
imshow(frame)
hold on
h=viscircles(center,radius,'Color','g');
hold off

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Wax
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% extract green wax
[wax,waxBW]=colorfilter(I,[70,250]);
wax=imrotate(wax,ang-90);
waxBW=imrotate(waxBW,ang-90);
% morphological opening and closing
se = strel('disk',2);
waxBW = imclose(waxBW,se);
waxBW = imopen(waxBW,se);
% compute overdrilling percentage
waxBW=imcomplement(waxBW);
L=bwlabel(waxBW);
remain=sum(sum(L==0));
overdrilled=0;
for i=2:length(unique(L))-1
    overdrilled=overdrilled+sum(sum(L==i));
end
% overdrilled=overdrilled-pi*radius^2
overdrilledP=100*overdrilled/(overdrilled+remain);
% compute underdrilling metric
score=mean(wax(wax~=0));
