# Installation Instructions

## Prerequisites

Before building this software, ensure you have the following installed:

- CMake (version 3.0 or higher)

- C++ compiler with C++11 support
- Required libraries (see Dependencies section)

## Dependencies

Install the following libraries:

- **Eigen3**: Linear algebra library
- **Boost**: C++ libraries (program_options, math, accumulators, geometry)
- **Optional**: PCL (Point Cloud Library)

### Installing Dependencies

#### Ubuntu/Debian:
```bash
sudo apt-get install cmake libeigen3-dev libboost-all-dev
```

#### macOS (with Homebrew):
```bash
brew install cmake eigen boost
```

#### Windows:
- Download and install CMake from https://cmake.org/
- Install Eigen3 and Boost libraries
- Configure your IDE to find these libraries

## Building the Software

1. **Clone or extract the source code**
   ```bash
   cd /path/to/cis
   ```

2. **Create build directory**
   ```bash
   mkdir build
   cd build
   ```

3. **Configure with CMake**
   ```bash
   cmake ..
   ```

4. **Build the software**
   ```bash
   make
   ```

5. **Run tests (optional)**
   ```bash
   make test
   ```

6. **Install (optional)**
   ```bash
   make install
   ```

## CMake Configuration Options

You can configure the build with additional options:

```bash
cmake -DOPTION=ON ..
```

Available options:
- `BUILD_TESTING=ON`: Build unit tests
- `BUILD_DOCUMENTATION=ON`: Build documentation
- `BUILD_EXAMPLE=OFF`: Skip example builds

## Troubleshooting

If you encounter build errors:

1. Ensure all dependencies are properly installed
2. Check that your compiler supports C++11
3. Verify CMake can find all required libraries
4. Check the CMake output for specific error messages

For additional help, refer to the documentation or contact the maintainers.