# CIS Programming Assignment Usage Guide

## Overview

This project implements the base structure for Computer Integrated Surgery (CIS) Programming Assignments 1 & 2:

- **PA1**: Basic transformations & pivot calibration
- **PA2**: Distortion calibration & application

## Building the Project

```bash
mkdir build
cd build
cmake ..
make
```

## Usage

The main executable `cisHW1-2` uses a subroutine dispatcher pattern. You can call individual subroutines by name:

```bash
./cisHW1-2 --subroutine <subroutine_name> --input <input_prefix>
```

### Available Subroutines

#### PA1 Subroutines:
- `pa1_basic_transformations` - Basic transformation computations
- `pa1_pivot_calibration_em` - EM pivot calibration
- `pa1_pivot_calibration_optical` - Optical pivot calibration  
- `pa1_frame_computation` - Frame computation and output generation

#### PA2 Subroutines:
- `pa2_distortion_calibration` - Distortion calibration
- `pa2_apply_distortion_correction` - Apply distortion correction
- `pa2_registration_computation` - Registration computation
- `pa2_pointer_tip_computation` - Pointer tip computation

### Examples

```bash
# Run basic transformations for PA1 debug data
./cisHW1-2 --subroutine pa1_basic_transformations --input pa1-debug

# Run EM pivot calibration
./cisHW1-2 --subroutine pa1_pivot_calibration_em --input pa1-debug

# Run distortion calibration for PA2
./cisHW1-2 --subroutine pa2_distortion_calibration --input pa2-debug

# Get help
./cisHW1-2 --help
```

### Input File Format

The `--input` parameter should be the prefix of your data files. For example, if you have:
- `pa1-debug-calbody.txt`
- `pa1-debug-calreadings.txt`
- `pa1-debug-empivot.txt`

Then use `--input pa1-debug`

## Implementation Status

All subroutines are currently implemented as stubs with TODO comments indicating what needs to be implemented. The structure is ready for you to fill in the actual algorithms.

## Dependencies

- Eigen3 (linear algebra)
- Boost (program options)
- C++11 compatible compiler
