import cv2
import numpy as np
import sys
import os

NUM_CHANNELS = 3
FPS = 30


def convert_opt_flow(clip_path, out_path):

    #Load in video
    try:
        cap = cv2.VideoCapture("testin.avi")
    except ValueError:
        print("\t\tIssue with video encoding. Skipping.")
        sys.stdout.flush()
        return None

    ret, frame = cap.read()
    # Define the codec and create VideoWriter object
    d1 = int(frame.shape[1])
    d2 = int(frame.shape[0])
    fourcc = cv2.VideoWriter_fourcc(*'DIVX')
    out = cv2.VideoWriter("test.avi", fourcc, 30.0, (d1,d2), True)
    while(ret == True):
        print("frame")
        out.write(frame)
        ret, frame = cap.read()
    cap.release()
    out.release()
    return


def get_flows():
    phase_clip_dir = '/home-2/gsilvac1@jhu.edu/work/gsilvac1/CATARACT/raw_data/cataract_phase_separated/'
    flow_out_dir = '/home-2/gsilvac1@jhu.edu/work/gsilvac1/CATARACT/optical_flow/data/'

    for i in range(1,11):
        print('\t\tCurrently on phase ' + str(i))
        print('-----------------------------------------------------------')
        sys.stdout.flush()

        spec_phase_clip_dir = phase_clip_dir + str(i) + '/'
        spec_phase_out_dir = flow_out_dir + str(i) + '/'
        phase_clip_names = os.listdir(spec_phase_clip_dir)
        for phase_clip in phase_clip_names:
            clip_path = spec_phase_clip_dir + phase_clip
            out_path = spec_phase_out_dir + phase_clip
            convert_opt_flow(clip_path, out_path)
            break
        break
        print('')


if __name__ == "__main__":
    convert_opt_flow('a', 'c')
