import simpy
import pandas            as pd
import numpy             as np
import matplotlib.pyplot as plt
from importdata        import import_datafromfiles
from gethistoricalinfo import get_historicalinfo
from createsimulation  import run_simulation
from getplots          import get_plots
from Stat_Tests        import stats_tests


## IMPORT DATA ##

# Import data from csv files containing basic patient info and adt data
# Function returns dataframes with the data formatted correctly, only the relevant
# (4P unit) patients included, and anomalous patients removed according to cutoff

#BIs, ADTs = import_datafromfiles('BasicInfo_HCGH.csv','ADT_HCGH.csv', 100)
#ADTs.to_pickle('ADTs.pkl')
#BIs.to_pickle('BIs.pkl')

# If files have already been created one can obtain these directly instead of using
# import function
BIs = pd.read_pickle('BIs.pkl')
ADTs = pd.read_pickle('ADTs.pkl')

## HISTORICAL DATA MANIPULATION ##

# Get census array and lookup table for duration distributions and patient per hour
# probability distribution
census_array, dur_prob_array = get_historicalinfo(ADTs)

## RUN SIMULATION ##

# Run the simulation from the start time to end time and get census output that 
# is based on the historical data distributions
env = simpy.Environment()
start_time = pd.to_datetime('01/01/2018 07:00', format='%m/%d/%Y %H:%M')
end_time = pd.to_datetime('01/05/2018 07:00', format='%m/%d/%Y %H:%M')
census = run_simulation(env,start_time,end_time,census_array,dur_prob_array)

# Can save a file of the simulated census values
np.save('census_filename.npy', census)

# If a census file has already been created you can load it here
census = np.load('census_filename.npy')

## VISUALIZE RESULTS ##

# Plot
get_plots(census,start_time,end_time,hist_census=True,census_array=census_array)
#get_plots(census,start_time1,end_time1,census2,start_time2,end_time2,hist_census=True,census_array=census_array)

# RUN STATISTICAL TESTS ##	

stats_tests(census,start_time,end_time,census_array)














