import random
import simpy
import pandas as pd
import numpy as np
import datetime

''' This file uses the historical adt dataframe in order to obtain census values given the temporal parameters
	by running the historical values through the simulation.
	Inputs of function run_hist_simulation:
	env-                 the simpy environment to run the simulation on
	start_time-          the first time given by the historical adt data
	end_time-            the last time given by the historical adt data
	in_time_dict-        a dictionary with keys- hour of arrival of patients and values are a list of the visit IDs of patients entering at that hour
	fourpdurations_dict- a dictionary whose keys are visit IDs and values are the corresponding total duration in 4P
	Outputs of function run_hist_simulation:
	CENSUS_ARRAY- an 4x7x4 array that is split into 4 seasons, 7 days of the week, 4 times of day, each value is a census value for the given time
'''      
# Patient class keeps track of patient's ID, current department, and movement history
class Patient:
    
    # Attributes TBD
    def __init__(self, age, gender):
        self.age = age
        self.gender = gender

# Get user input for what date/times the simulation should begin and end
def get_input():
    start_date = input("What is the date and time that you want the simulation to begin? Please use the format 'MM/DD/YYYY ##:##' (use military time): ")
    end_date = input("What is the date and time that you want the simulation to end? Please use the format 'MM/DD/YYYY ##:##' (use military time): ")
    start_time = pd.to_datetime(start_date, format='%m/%d/%Y %H:%M')
    end_time = pd.to_datetime(end_date, format='%m/%d/%Y %H:%M')
    return [start_time, end_time]
    
# Determine whether a given time is within a given time range
def time_in_range(start, end, t):
    if(start <= end):
        return start <= t <= end
    else:
        return start <= t or t <= end
        
# Find time range that current time falls under
def get_timerange(time):
    
    if time_in_range(7,15,time):
        return 0
    elif time_in_range(15,19,time):
        return 1
    elif time_in_range(19,23,time):
        return 2
    elif time_in_range(23,7,time):
        return 3

# Add new patients
def source_patients(env, times):
	start_time = times[0]
	sim_time = times[0]
	end_time = times[1]

	global CENSUS_ARRAY
	global CURR_CENSUS
	while sim_time < end_time:
		Month = sim_time.month
		if Month in [12,1,2]:
			Season = 0
		if Month in [3,4,5]:
			Season = 1
		if Month in [6,7,8]:
			Season = 2
		if Month in [9,10,11]:
			Season = 3
		Dayofweek = sim_time.weekday()
		Time_Range = get_timerange(sim_time.hour)
		if sim_time in In_Time_Dict:
			VisitIDlist = In_Time_Dict.get(sim_time)
			for ID in VisitIDlist:
				Duration = FourPDurations_Dict[ID]
				p = Patient(18, 'F')
				arrive = env.now
				#print(arrive, "Patient arrived")
				CURR_CENSUS += 1
				#print(CURR_CENSUS)
				s_p = simulate_patient(env, p, Duration,Season,Dayofweek,Time_Range)
				env.process(s_p)
		if CENSUS_ARRAY[Season][Dayofweek][Time_Range] == None:
			CENSUS_ARRAY[Season][Dayofweek][Time_Range] = list()
		if (sim_time - start_time).days > 10:
			CENSUS_ARRAY[Season][Dayofweek][Time_Range].append(CURR_CENSUS)

		yield env.timeout(60)
		sim_time = sim_time + datetime.timedelta(hours=1)

def simulate_patient(env, patient, duration,season,dayofweek,timerange):
    global CENSUS_ARRAY
    global CURR_CENSUS

    yield env.timeout(duration)
    depart = env.now
    #print(depart, "Patient departed")
    CURR_CENSUS -= 1
 
# Runs simulation and outputs census history
# Inputs should be datetime objects
def run_hist_simulation(env, start_time, end_time, in_time_dict, fourpdurations_dict):
    global CENSUS_ARRAY
    global CURR_CENSUS
    global In_Time_Dict
    global FourPDurations_Dict

    In_Time_Dict = in_time_dict
    FourPDurations_Dict = fourpdurations_dict

    CENSUS_ARRAY = np.empty([4,7,4],dtype = object)
    CURR_CENSUS = 0

    sim_times = [start_time, end_time]
    env.process(source_patients(env,sim_times))
    env.run()
    return CENSUS_ARRAY
