import numpy as np
import pandas as pd
import simpy
import matplotlib.pyplot as plt
import scipy.stats as stats
from gethistorical import get_historicalcensus

''' This function runs statistical tests comparing the simulated census to the corresponding
	historical one and prints the results.
    Inputs: 
	sim_census- a list (or array) of census values simulated given the start and end time
	start_date- the start time of the simulated census
	end_date- the end time of the simulated census
	census_array- a 4x7x4 array that has a distribution of census values for the season, dayofweek, 
				  and time range
    Outputs:
	Prints the results of a t-test and a Pearson's correlation test
'''
def stats_tests(sim_census,start_date,end_date,census_array):

	sim_mean = sim_census
	#sim_mean = np.mean(sim_census, axis=0) # if using array of census values get the mean

	# Get corresponding historical census
	hist_census = get_historicalcensus(start_date, end_date,census_array)

	# Obtain mean for each hour of historical census
	hist_mean = []
	for i in range(len(hist_census)):
		hist_mean.append(np.mean(hist_census[i]))

	tstat, tp = stats.ttest_ind(sim_census,hist_mean)
	print(stats.ttest_ind(sim_census,hist_mean))
	print(np.mean(tp))

	print(stats.pearsonr(sim_mean,hist_mean))



