import simpy
import pandas as pd
import datetime
from getstartingcensus import get_census
from gettimeleft import get_timeleft_new
from getduration import get_duration_new

# Global census history for each period of time (currently hour)
CENSUS = list()
CUR_CENSUS = 0
# 1:5 nurse-patient ratio history that matches census
NURSES = list()
# Patients turned away each period of time (currently hour)
REJECTED = list()
        
# Patient class keeps track of patient's ID, current department, and movement history
class Patient:
    
    # Attributes TBD
    def __init__(self, age, gender):
        self.age = age
        self.gender = gender

# Get user input for what date/times the simulation should begin and end
def get_input():
    start_date = input("What is the date and time that you want the simulation to begin? Please use the format 'MM/DD/YYYY ##:##' (use military time): ")
    end_date = input("What is the date and time that you want the simulation to end? Please use the format 'MM/DD/YYYY ##:##' (use military time): ")
    start_time = pd.to_datetime(start_date, format='%m/%d/%Y %H:%M')
    end_time = pd.to_datetime(end_date, format='%m/%d/%Y %H:%M')
    return [start_time, end_time]
    
# Determine whether a given time is within a given time range
def time_in_range(start, end, t):
    if(start <= end):
        return start <= t <= end
    else:
        return start <= t or t <= end
        
# Find time range that current time falls under
def get_timerange(time):
    
    # Time ranges that are currently used at the hospital: morning (7am-3pm), afternoon (3pm-7pm), evening(7pm-11pm), late night(11pm-7am)
    mornStart = datetime.time(7,0,0)
    mornEnd = datetime.time(15,0,0)
    midStart = datetime.time(15,0,0)
    midEnd = datetime.time(19,0,0)
    eveStart = datetime.time(19,0,0)
    eveEnd = datetime.time(23,0,0)
    lateStart = datetime.time(23,0,0)
    lateEnd = datetime.time(7,0,0)
    
    # Check which range the given time is in and return the start and end of the range
    if time_in_range(mornStart,mornEnd,time):
        return [7,15]
    elif time_in_range(midStart,midEnd,time):
        return [15,19]
    elif time_in_range(eveStart,eveEnd,time):
        return [19,23]
    elif time_in_range(lateStart,lateEnd,time):
        return [23,7]

# Implement durations for starting patients, get # as input? Both ways? For now, use input, ideally it would be optional and could be sampled by the program

# Add new patients
def source_patients(env, times):
    sim_time = times[0]
    end_time = times[1]
    
    dept = 'HCGH 4P ACUTE'
    global CENSUS
    global CUR_CENSUS
    global NURSES
    # Currently arbitrary - can either be inputted or gotten from data
    #CUR_CENSUS = 25
    CUR_CENSUS = get_census(sim_time,array)
    #print('got initial census')
    #print(CUR_CENSUS)
    
    # Assign times for discharge of patients currently in unit
    cur_time = sim_time.time()
    time_range = get_timerange(cur_time)
    durations = get_timeleft_new(sim_time,time_range[0],time_range[1],CUR_CENSUS,lookup)
    # Create patients currently in unit and put them through simulation
    for i in range(len(durations)):
        p = Patient(18, 'F')
        arrive = env.now
        #print(arrive, sim_time, " Patient arrived")
        s_p = simulate_patient(env, p, durations[i-1])
        env.process(s_p)
    
    # Check every hour if new patients should be admitted
    while(sim_time < end_time):
        cur_time = sim_time.time()
        # Get list of durations depending on what time range the current time falls in
        time_range = get_timerange(cur_time)
        durations = get_duration_new(sim_time,time_range[0],time_range[1],lookup)
        # Update census and nurses history
        CENSUS.append(CUR_CENSUS)
        nurses = int(CUR_CENSUS / 5)
        if(CUR_CENSUS % 5 > 0):
            nurses += 1
        NURSES.append(nurses)
        # Update census using the list of new admitted patient durations
        CUR_CENSUS = CUR_CENSUS + len(durations)
        # Check if census goes over maximum - if so, turn away the extra patients and record how many are turned away
        if(CUR_CENSUS > 30):
            excess = CUR_CENSUS - 30
            REJECTED.append(excess)
            end_index = len(durations) - excess
            durations = durations[0:end_index]
            CUR_CENSUS = 30 # account for max beds
        # Create and simulate new patients
        for i in range(len(durations)):
            p = Patient(18, 'F')
            arrive = env.now
            #print(arrive, sim_time, " Patient arrived")
            s_p = simulate_patient(env, p, durations[i-1])
            env.process(s_p)
        # Check every hour
        yield env.timeout(60)
        # Update date-time
        sim_time = sim_time + datetime.timedelta(hours=1)
        if(sim_time >= end_time):
            CENSUS.append(CUR_CENSUS)
            NURSES.append(nurses)
        # print(CENSUS)
        # print(REJECTED)
    #return CENSUS

# Have patients leave when duration is over and update census
def simulate_patient(env, patient, duration):
    global CUR_CENSUS
    yield env.timeout(duration)
    depart = env.now
    #print(depart, " Patient departed")
    CUR_CENSUS -= 1
    
# Runs simulation and outputs census history
# Inputs should be datetime objects
def run_simulation(env, start_time, end_time,census_array,lookup_in):
    # Reset global variables
    global CENSUS
    global CUR_CENSUS
    global array
    global lookup
    array = census_array
    lookup = lookup_in
    CENSUS = list()
    CUR_CENSUS = 0
    # Run simulation
    sim_times = [start_time, end_time]
    env.process(source_patients(env, sim_times))
    env.run()
    return CENSUS

