import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import datetime

''' This function obtains the historical census distribution for each hour between the time parameters.
    Inputs: 
    start_time- the start time of desired historical census data desired
    end_time- the end time of desired historical census data desired
    census_array- a 4x7x4 array that has a distribution of census values for the season, dayofweek,
    			  and time range; an output of the get_historicalinfo function
    Outputs:
	Census_Return- a list of lists where each element represents an hour of the time range and contains
				   a distribution of census values for that hour
'''
# Determine whether a given time is within a given time range
def time_in_range(start, end, t):
    if(start <= end):
        return start <= t <= end
    else:
        return start <= t or t <= end
        
# Find time range that current time falls under
def get_timerange(time):
    
    if time_in_range(7,15,time):
        return 0
    elif time_in_range(15,19,time):
        return 1
    elif time_in_range(19,23,time):
        return 2
    elif time_in_range(23,7,time):
        return 3

def get_historicalcensus(start_time, end_time,census_array):
	Census_Return = []

	curr_time = start_time
	while(curr_time<=end_time):
		Month = curr_time.month
		if Month in [12,1,2]:
			Season = 0
		if Month in [3,4,5]:
			Season = 1
		if Month in [6,7,8]:
			Season = 2
		if Month in [9,10,11]:
			Season = 3
		Dayofweek = curr_time.weekday()
		Time_Range = get_timerange(curr_time.hour)
		census_list = census_array[Season][Dayofweek][Time_Range]
		Census_Return.append([census_list])
		curr_time = curr_time + datetime.timedelta(hours=1)

	return Census_Return

