import pandas as pd
import numpy as np
import simpy
from getdictionaries      import get_dictionaries
from HistoricalSimulation import run_hist_simulation
from createlookup         import create_lookup

''' This file analyzes the historical adt information in order to obtain information regarding the historical census
	over time and create a lookup table of historical duration distributions given temporal data to speed up use of
	the simulation.
	Inputs:
	adt_dataframe- a pandas dataframe that contains historical adt data of 4P patients
	Outputs:
	census_array- a 4x7x4 array that has a distribution of census values for the season, dayofweek, and time range
	DurProbArray- a 4x7x4x2 array that is split by season, dayofweek, and time range; its first element is a 
				  distribution of durations in 4P for patients who entered at that time, the second element is a 
				  probability distribution of the patients per hour at that time
'''
def get_historicalinfo(adt_dataframe):
	'''
	# One can create and save the dictionaries using the get_dictionaries function
	In_Time_Dict, FourPDurations_Dict = get_dictionaries(adt_dataframe)
	np.save('In_Time_Dict.npy', In_Time_Dict)
	np.save('FourPDurations_Dict.npy', FourPDurations_Dict)'''

	# Once the dictionaries have already been created they can be obtained directly
	In_Time_Dict = np.load('In_Time_Dict.npy').item()
	FourPDurations_Dict = np.load('FourPDurations_Dict.npy').item()

	'''
	# Can create the census array using the following code
	# This array is a 4x7x4 array that is split into 4 seasons, 7 days of the week, and 4 time ranges, respectively
	# It contains a distribution of the census values for the given time
	env = simpy.Environment()
	hist_start_time = min(list(In_Time_Dict.keys()))
	hist_end_time   = max(list(In_Time_Dict.keys()))
	census_array = run_hist_simulation(env,hist_start_time,hist_end_time,In_Time_Dict,FourPDurations_Dict)
	np.save('census_array.npy', census_array)'''

	# Census array can be obtained directly from the file once it is created and saved
	census_array = np.load('census_array.npy')

	
	'''# Can create the lookup table of durations and probability distribution of number of patients per hour
	# for each season, dayofweek, and time range
	DurProbArray = create_lookup(adt_dataframe)
	#np.save('duration_array.npy', DurProbArray)'''
		
	# Duration distribution and patient per hour probability distribution can be obtained from the file directly
	# once it is created
	DurProbArray = np.load('duration_array.npy')

	return census_array, DurProbArray


