import numpy             as np
import matplotlib.pyplot as plt
from gethistorical import get_historicalcensus


''' This function plots the simulated census. It can also plot the corresponding historical census or
	plot two simulated censuses simultaneously.
	Inputs:
	sim_census- a list of census values over time, can also be an array
	start_date- the initial time of the simulation
	end_date- the final time of the simulation
	sim_census2- a second list or array of census values to plot
	start_date2- the start time of the second census
	end_date2- the end time of the second census
	hist_census- a boolean indicating whether or not to plot the corresponding historical census(es)
	census_array- an array used to obtain historical census(es) to plot
	Outputs:
	creates a plot of census values vs time
'''
def get_plots(sim_census,start_date,end_date,sim_census2=None,start_date2=None,end_date2=None,hist_census=False,census_array=None):

	sim_mean = sim_census
	#sim_mean = np.mean(sim_census,axis=0) #if sim_census is an array of censuses
	plt.plot(sim_mean, '-b')
	plt.ylim(0,32)

	#sim_census2 = None

	if sim_census2 != None:
		sim_mean2 = np.mean(sim_census2,axis=0)
		plt.plot(sim_mean2,'-r')

	if hist_census==True:
		hist_census = get_historicalcensus(start_date, end_date,census_array)
		hist_mean = []
		hist_95 = []
		hist_75 = []
		hist_05 = []
		hist_25 = []
		for i in range(len(hist_census)):
			hist_mean.append(np.mean(hist_census[i]))
			hist_95.append(np.percentile(hist_census[i],95))
			hist_75.append(np.percentile(hist_census[i],75))
			hist_05.append(np.percentile(hist_census[i], 5))
			hist_25.append(np.percentile(hist_census[i],25))
		plt.plot(hist_mean, '--k')
		#plt.plot(hist_95, '--k')
		#plt.plot(hist_75, '--b')
		#plt.plot(hist_25, '--b')
		#plt.plot(hist_05, '--k')
		if sim_census2!=None:
			hist_census2 = get_historicalcensus(start_date2, end_date2,census_array)
			hist_mean2 = []
			hist_952 = []
			hist_752 = []
			hist_052 = []
			hist_252 = []
			for i in range(len(hist_census2)):
				hist_mean2.append(np.mean(hist_census2[i]))
				hist_952.append(np.percentile(hist_census2[i],95))
				hist_752.append(np.percentile(hist_census2[i],75))
				hist_052.append(np.percentile(hist_census2[i], 5))
				hist_252.append(np.percentile(hist_census2[i],25))
			#plt.plot(hist_mean2, '--k')
			#plt.plot(hist_952, '--k')
			#plt.plot(hist_752, '--r')
			#plt.plot(hist_252, '--r')
			#plt.plot(hist_052, '--k')

	#plt.title('Patient Census Monday 7am - Monday 6am')

	#plt.xlabel('Time of Day')
	#Days = ['Mon', 'Tues', 'Wed', 'Thurs', 'Fri', 'Sat', 'Sun'] + ['Mon']
	#plt.xticks(list(range(0,len(sim_mean)+1,24)),Days)

	#plt.legend(('Simulated Summer Mean','Historical Summer Mean','Historical 95% Confidence Interval'))

	plt.show()

