import datetime
import random

# Determines if t is between start and end
def time_in_range(start, end, t):
    if(start <= end):
        return start <= t <= end
    else:
        return start <= t or t <= end
        
# Find time range that current time falls under
def get_timerange(time):
    
    if time_in_range(7,15,time):
        return 0
    elif time_in_range(15,19,time):
        return 1
    elif time_in_range(19,23,time):
        return 2
    elif time_in_range(23,7,time):
        return 3

''' Function that obtains a census value given a simulation time 
	and an array of historical census data organized by season, 
	day of week, and time range.
	Inputs:
	sim_date-     a pandas datetime of the current simulation time
	census_array- a 4x7x4 array of lists census values for each time
	Output:
	Census_Val- a value for the starting census at the given time
'''
def get_census(sim_date,census_array):
	# Go back one hour to determine census before simulation begins
	sim_date = sim_date - datetime.timedelta(hours=1)

	# Determine temporal parameters
	Month = sim_date.month
	if Month in [12,1,2]:
		Season = 0
	if Month in [3,4,5]:
		Season = 1
	if Month in [6,7,8]:
		Season = 2
	if Month in [9,10,11]:
		Season = 3
	Dayofweek = sim_date.weekday()
	Time_Range = get_timerange(sim_date.hour)

	# Obtain list of historical census values given the time
	Censuses = census_array[Season][Dayofweek][Time_Range]

	# Choose a census value randomly
	Chosen = random.randint(0,len(Censuses)-1)
	Census_Val = Censuses[Chosen]
	
	return Census_Val
